/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.components.config.xml;

import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class StateHandlerAnnotationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private ProcessEngine processEngine;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    private void configureDefaultActivitiRegistry(String registryBeanName, BeanDefinitionRegistry registry) {
        if (!this.beanAlreadyConfigured(registry, registryBeanName, ActivitiStateHandlerRegistry.class)) {
            String registryName = ActivitiStateHandlerRegistry.class.getName();
            this.log.info("registering a " + registryName + " instance under bean name " + "activitiComponentRegistry" + ".");
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
            rootBeanDefinition.setBeanClassName(registryName);
            rootBeanDefinition.getPropertyValues().addPropertyValue("processEngine", (Object)this.processEngine);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)rootBeanDefinition, registryBeanName);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.configureDefaultActivitiRegistry("activitiComponentRegistry", registry);
        } else {
            this.log.info("BeanFactory is not a BeanDefinitionRegistry. The default 'activitiComponentRegistry' cannot be configured.");
        }
    }

    private boolean beanAlreadyConfigured(BeanDefinitionRegistry registry, String beanName, Class clz) {
        if (registry.isBeanNameInUse(beanName)) {
            BeanDefinition bDef = registry.getBeanDefinition(beanName);
            if (bDef.getBeanClassName().equals(clz.getName())) {
                return true;
            }
            throw new IllegalStateException("The bean name '" + beanName + "' is reserved.");
        }
        return false;
    }
}

