/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.application;

import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.spring.test.application.PostDeployRegistrationPa;
import org.camunda.bpm.engine.spring.test.application.PostDeployWithNestedContext;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringProcessApplicationTest {
    @Test
    public void testProcessApplicationDeployment() {
        Assert.assertEquals((long)0L, (long)BpmPlatform.getProcessApplicationService().getProcessApplicationNames().size());
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/camunda/bpm/engine/spring/test/application/SpringProcessApplicationDeploymentTest-context.xml");
        applicationContext.start();
        Assert.assertNotNull((Object)BpmPlatform.getProcessApplicationService().getProcessApplicationInfo("myProcessApplication"));
        applicationContext.close();
        Assert.assertNull((Object)BpmPlatform.getProcessApplicationService().getProcessApplicationInfo("myProcessApplication"));
    }

    @Test
    public void testDeployProcessArchive() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/camunda/bpm/engine/spring/test/application/SpringProcessArchiveDeploymentTest-context.xml");
        applicationContext.start();
        ProcessEngine processEngine = BpmPlatform.getDefaultProcessEngine();
        Assert.assertNotNull((Object)processEngine.getRepositoryService().createDeploymentQuery().deploymentName("pa").singleResult());
        applicationContext.close();
        Assert.assertNull((Object)processEngine.getRepositoryService().createDeploymentQuery().deploymentName("pa").singleResult());
    }

    @Test
    public void testPostDeployRegistrationPa() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/camunda/bpm/engine/spring/test/application/PostDeployRegistrationPaTest-context.xml");
        applicationContext.start();
        ProcessEngine processEngine = BpmPlatform.getDefaultProcessEngine();
        Deployment deployment = processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/spring/test/application/process.bpmn20.xml").deploy();
        PostDeployRegistrationPa processApplication = (PostDeployRegistrationPa)((Object)applicationContext.getBean("customProcessApplicaiton", PostDeployRegistrationPa.class));
        Assert.assertFalse((boolean)processApplication.isPostDeployInvoked());
        processApplication.deploy();
        Assert.assertTrue((boolean)processApplication.isPostDeployInvoked());
        Assert.assertFalse((boolean)processApplication.isInvoked());
        processEngine.getRuntimeService().startProcessInstanceByKey("startToEnd");
        Assert.assertTrue((boolean)processApplication.isInvoked());
        Assert.assertFalse((boolean)processApplication.isPreUndeployInvoked());
        processApplication.undeploy();
        Assert.assertTrue((boolean)processApplication.isPreUndeployInvoked());
        processEngine.getRepositoryService().deleteDeployment(deployment.getId(), true);
        applicationContext.close();
    }

    @Test
    public void testPostDeployWithNestedContext() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("org/camunda/bpm/engine/spring/test/application/PostDeployWithNestedContext-context.xml");
        applicationContext.start();
        PostDeployWithNestedContext processApplication = (PostDeployWithNestedContext)((Object)applicationContext.getBean("customProcessApplicaiton", PostDeployWithNestedContext.class));
        Assert.assertFalse((boolean)processApplication.isDeployOnChildRefresh());
        Assert.assertTrue((boolean)processApplication.isLateEventTriggered());
        processApplication.undeploy();
        applicationContext.close();
    }
}

