/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.spring.test.SpringProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:org/camunda/bpm/engine/spring/test/components/SpringjobExecutorTest-context.xml"})
public class SpringJobExecutorTest
extends SpringProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/spring/test/components/SpringTimersProcess.bpmn20.xml", "org/camunda/bpm/engine/spring/test/components/SpringJobExecutorRollBack.bpmn20.xml"})
    public void testHappyJobExecutorPath() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process1");
        SpringJobExecutorTest.assertNotNull((Object)instance);
        this.waitForJobExecutorToProcessAllJobs(10000L);
        List activeTasks = this.taskService.createTaskQuery().processInstanceId(instance.getId()).list();
        SpringJobExecutorTest.assertTrue((activeTasks.size() == 0 ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/spring/test/components/SpringTimersProcess.bpmn20.xml", "org/camunda/bpm/engine/spring/test/components/SpringJobExecutorRollBack.bpmn20.xml"})
    public void testRollbackJobExecutorPath() throws Exception {
        this.processEngineConfiguration.getJobExecutor().shutdown();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("errorProcess1");
        SpringJobExecutorTest.assertNotNull((Object)instance);
        this.waitForJobExecutorToProcessAllJobs(10000L);
        List activeTasks = this.taskService.createTaskQuery().processInstanceId(instance.getId()).list();
        SpringJobExecutorTest.assertTrue((activeTasks.size() == 1 ? 1 : 0) != 0);
    }
}

