/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components.registry;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistration;
import org.junit.Assert;
import org.junit.Test;

public class ActivitiStateHandlerRegistrationTest {
    @Test
    public void shouldHaveDetailledStringRepresentation() throws Exception {
        Map<Integer, String> processVariablesExpected = Collections.singletonMap(34, "testValue");
        Method handlerMethod = this.getClass().getMethod("shouldHaveDetailledStringRepresentation", new Class[0]);
        Object handler = new Object(){
            public Integer testValue;
            {
                Integer n = this.testValue = Integer.valueOf(76);
                this.testValue = this.testValue + 1;
            }
        };
        String stateName = "running";
        String beanName = "testBean";
        int processVariablesIndex = 4;
        int processIdIndex = 2;
        String processName = "testProcess";
        ActivitiStateHandlerRegistration registration = new ActivitiStateHandlerRegistration(processVariablesExpected, handlerMethod, handler, stateName, beanName, processVariablesIndex, processIdIndex, processName);
        Assert.assertEquals((Object)("org.camunda.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistration@" + Integer.toHexString(registration.hashCode()) + "[processVariablesExpected={34=testValue}, handlerMethod=public void org.camunda.bpm.engine.spring.test.components.registry.ActivitiStateHandlerRegistrationTest.shouldHaveDetailledStringRepresentation() throws java.lang.Exception, handler=org.camunda.bpm.engine.spring.test.components.registry.ActivitiStateHandlerRegistrationTest$1@" + Integer.toHexString(handler.hashCode()) + ", stateName=running, beanName=testBean, processVariablesIndex=4, processIdIndex=2, processName=testProcess]"), (Object)registration.toString());
    }

    @Test
    public void shouldHaveDetailledStringRepresentationWithNullValues() throws Exception {
        Map<Integer, String> processVariablesExpected = Collections.singletonMap(34, "testValue");
        Method handlerMethod = null;
        Object handler = null;
        String stateName = "running";
        String beanName = "testBean";
        int processVariablesIndex = 4;
        int processIdIndex = 2;
        String processName = "testProcess";
        ActivitiStateHandlerRegistration registration = new ActivitiStateHandlerRegistration(processVariablesExpected, handlerMethod, handler, stateName, beanName, processVariablesIndex, processIdIndex, processName);
        Assert.assertEquals((Object)("org.camunda.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistration@" + Integer.toHexString(registration.hashCode()) + "[processVariablesExpected={34=testValue}, handlerMethod=null, handler=null, stateName=running, beanName=testBean, processVariablesIndex=4, processIdIndex=2, processName=testProcess]"), (Object)registration.toString());
    }
}

