/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.autodeployment;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class DynamicResourceProducer {
    private static List<Resource> resources = new ArrayList<Resource>();

    public static void clearResources() {
        resources.clear();
    }

    public static void addResource(String name, BpmnModelInstance modelInstance) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)modelInstance);
        resources.add((Resource)new NamedByteArrayResource(outStream.toByteArray(), name));
    }

    public static Resource[] getResources() {
        return resources.toArray(new Resource[resources.size()]);
    }

    public static class NamedByteArrayResource
    extends ByteArrayResource {
        private String description;

        public NamedByteArrayResource(byte[] byteArray, String description) {
            super(byteArray, description);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

