/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.dmn;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.RepositoryService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/dmn/DmnJuelTest-applicationContext.xml"})
public class DmnJuelTest {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected DecisionService decisionService;
    protected String deploymentId;

    @Before
    public void deploy() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/spring/test/dmn/JuelTest.dmn").deploy().getId();
    }

    @After
    public void clean() {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    @Test
    public void shouldResolveBean() {
        DmnDecisionResult result = this.decisionService.evaluateDecisionByKey("drg-with-bean-expression").evaluate();
        Assertions.assertThat((String)((String)result.getSingleEntry())).isEqualTo((Object)"bar");
    }
}

