/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring;

import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionInterceptor
extends CommandInterceptor {
    protected PlatformTransactionManager transactionManager;
    protected int transactionPropagation;

    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager, int transactionPropagation) {
        this.transactionManager = transactionManager;
        this.transactionPropagation = transactionPropagation;
    }

    public <T> T execute(final Command<T> command) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(this.transactionPropagation);
        Object result = transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return SpringTransactionInterceptor.this.next.execute(command);
            }
        });
        return (T)result;
    }
}

