/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.impl.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public class SpringProcessEngineTestCase
extends AbstractProcessEngineTestCase
implements ApplicationContextAware {
    protected TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());
    @Autowired
    protected ConfigurableApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        try {
            super.runBare();
        }
        finally {
            this.testContextManager.afterTestClass();
            this.applicationContext.close();
            this.clearTestContextCache(this.testContextManager);
            this.applicationContext = null;
            this.processEngine = null;
            this.testContextManager = null;
            CachedIntrospectionResults.clearClassLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
    }

    private final void clearTestContextCache(TestContextManager testContextManager) throws Exception {
        Field contextCacheField = TestContextManager.class.getDeclaredField("contextCache");
        contextCacheField.setAccessible(true);
        Object cache = contextCacheField.get(null);
        Method method = cache.getClass().getDeclaredMethod("clear", new Class[0]);
        method.setAccessible(true);
        method.invoke(cache, new Object[0]);
    }

    protected void initializeProcessEngine() {
        ContextConfiguration contextConfiguration = ((Object)((Object)this)).getClass().getAnnotation(ContextConfiguration.class);
        this.processEngine = (ProcessEngine)this.applicationContext.getBean(ProcessEngine.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

