/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.embedded;

import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.application.impl.embedded.TestApplicationReusingExistingEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithCustomEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutProcesses;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class EmbeddedProcessApplicationTest
extends PluggableProcessEngineTestCase {
    public void testDeployAppWithoutEngine() {
        TestApplicationWithoutEngine processApplication = new TestApplicationWithoutEngine();
        processApplication.deploy();
        processApplication.undeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeployAppWithoutProcesses() {
        RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
        runtimeContainerDelegate.registerProcessEngine(this.processEngine);
        try {
            TestApplicationWithoutProcesses processApplication = new TestApplicationWithoutProcesses();
            processApplication.deploy();
            ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getDefaultProcessEngine();
            long deployments = processEngine.getRepositoryService().createDeploymentQuery().count();
            EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)deployments);
            processApplication.undeploy();
        }
        finally {
            runtimeContainerDelegate.unregisterProcessEngine(this.processEngine);
        }
    }

    public void testDeployAppWithCustomEngine() {
        TestApplicationWithCustomEngine processApplication = new TestApplicationWithCustomEngine();
        processApplication.deploy();
        ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getProcessEngine("embeddedEngine");
        EmbeddedProcessApplicationTest.assertNotNull((Object)processEngine);
        EmbeddedProcessApplicationTest.assertEquals((String)"embeddedEngine", (String)processEngine.getName());
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        EmbeddedProcessApplicationTest.assertEquals((boolean)true, (boolean)configuration.isJobExecutorDeploymentAware());
        EmbeddedProcessApplicationTest.assertEquals((int)5, (int)configuration.getJdbcMaxActiveConnections());
        processApplication.undeploy();
    }

    public void testDeployAppReusingExistingEngine() {
        RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
        runtimeContainerDelegate.registerProcessEngine(this.processEngine);
        TestApplicationReusingExistingEngine processApplication = new TestApplicationReusingExistingEngine();
        processApplication.deploy();
        EmbeddedProcessApplicationTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        processApplication.undeploy();
        EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        runtimeContainerDelegate.unregisterProcessEngine(this.processEngine);
    }
}

