/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.identity.TestResource;

public class AuthorizationQueryTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        TestResource resource1 = new TestResource("resource1", 100);
        TestResource resource2 = new TestResource("resource2", 101);
        this.createAuthorization("user1", null, resource1, "resource1-1", new Permission[]{Permissions.ACCESS});
        this.createAuthorization("user1", null, resource2, "resource2-1", new Permission[]{Permissions.DELETE});
        this.createAuthorization("user2", null, resource1, "resource1-2", new Permission[0]);
        this.createAuthorization("user3", null, resource2, "resource2-1", new Permission[]{Permissions.READ, Permissions.UPDATE});
        this.createAuthorization(null, "group1", resource1, "resource1-1", new Permission[0]);
        this.createAuthorization(null, "group1", resource1, "resource1-2", new Permission[]{Permissions.UPDATE});
        this.createAuthorization(null, "group2", resource2, "resource2-2", new Permission[]{Permissions.READ, Permissions.UPDATE});
        this.createAuthorization(null, "group3", resource2, "resource2-3", new Permission[]{Permissions.DELETE});
    }

    protected void tearDown() throws Exception {
        List list = this.authorizationService.createAuthorizationQuery().list();
        for (Authorization authorization : list) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        super.tearDown();
    }

    protected void createAuthorization(String userId, String groupId, Resource resourceType, String resourceId, Permission ... permissions) {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(userId);
        authorization.setGroupId(groupId);
        authorization.setResource(resourceType);
        authorization.setResourceId(resourceId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.authorizationService.saveAuthorization(authorization);
    }

    public void testValidQueryCounts() {
        TestResource resource1 = new TestResource("resource1", 100);
        TestResource resource2 = new TestResource("resource2", 101);
        TestResource nonExisting = new TestResource("non-existing", 102);
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user2"}).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user3"}).count());
        AuthorizationQueryTest.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1", "user2"}).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"non-existing"}).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group3"}).count());
        AuthorizationQueryTest.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1", "group2"}).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"non-existing"}).count());
        AuthorizationQueryTest.assertEquals((long)4L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)resource1).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)nonExisting).count());
        AuthorizationQueryTest.assertEquals((long)4L, (long)this.authorizationService.createAuthorizationQuery().resourceType(resource1.resourceType()).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType(nonExisting.resourceType()).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().resourceId("resource1-2").count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceId("non-existing").count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.DELETE).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).count());
        AuthorizationQueryTest.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.UPDATE).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.UPDATE).count());
        AuthorizationQueryTest.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.UPDATE).hasPermission((Permission)Permissions.READ).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)resource1).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)nonExisting).count());
        AuthorizationQueryTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).resourceType((Resource)resource2).count());
        AuthorizationQueryTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).resourceType((Resource)nonExisting).count());
    }

    public void testValidQueryLists() {
        TestResource resource1 = new TestResource("resource1", 100);
        TestResource resource2 = new TestResource("resource2", 101);
        TestResource nonExisting = new TestResource("non-existing", 102);
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user2"}).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user3"}).list().size());
        AuthorizationQueryTest.assertEquals((int)3, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1", "user2"}).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"non-existing"}).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group3"}).list().size());
        AuthorizationQueryTest.assertEquals((int)3, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1", "group2"}).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"non-existing"}).list().size());
        AuthorizationQueryTest.assertEquals((int)4, (int)this.authorizationService.createAuthorizationQuery().resourceType((Resource)resource1).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().resourceType((Resource)nonExisting).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().resourceId("resource1-2").list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().resourceId("non-existing").list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.ACCESS).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.DELETE).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).list().size());
        AuthorizationQueryTest.assertEquals((int)3, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.UPDATE).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.UPDATE).list().size());
        AuthorizationQueryTest.assertEquals((int)2, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.UPDATE).hasPermission((Permission)Permissions.READ).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)Permissions.READ).hasPermission((Permission)Permissions.ACCESS).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)resource1).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)nonExisting).list().size());
        AuthorizationQueryTest.assertEquals((int)1, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).resourceType((Resource)resource2).list().size());
        AuthorizationQueryTest.assertEquals((int)0, (int)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).resourceType((Resource)nonExisting).list().size());
    }

    public void testOrderByQueries() {
        TestResource resource1 = new TestResource("resource1", 100);
        TestResource resource2 = new TestResource("resource2", 101);
        List list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceType().asc()).list();
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(0)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(1)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(2)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(3)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(4)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(5)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(6)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(7)).getResourceType());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceType().desc()).list();
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(0)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(1)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(2)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource2.resourceType(), (int)((Authorization)list.get(3)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(4)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(5)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(6)).getResourceType());
        AuthorizationQueryTest.assertEquals((int)resource1.resourceType(), (int)((Authorization)list.get(7)).getResourceType());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceId().asc()).list();
        AuthorizationQueryTest.assertEquals((String)"resource1-1", (String)((Authorization)list.get(0)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-1", (String)((Authorization)list.get(1)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-2", (String)((Authorization)list.get(2)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-2", (String)((Authorization)list.get(3)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-1", (String)((Authorization)list.get(4)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-1", (String)((Authorization)list.get(5)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-2", (String)((Authorization)list.get(6)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-3", (String)((Authorization)list.get(7)).getResourceId());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceId().desc()).list();
        AuthorizationQueryTest.assertEquals((String)"resource2-3", (String)((Authorization)list.get(0)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-2", (String)((Authorization)list.get(1)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-1", (String)((Authorization)list.get(2)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource2-1", (String)((Authorization)list.get(3)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-2", (String)((Authorization)list.get(4)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-2", (String)((Authorization)list.get(5)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-1", (String)((Authorization)list.get(6)).getResourceId());
        AuthorizationQueryTest.assertEquals((String)"resource1-1", (String)((Authorization)list.get(7)).getResourceId());
    }

    public void testInvalidOrderByQueries() {
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceType().list();
            AuthorizationQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceId().list();
            AuthorizationQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceId().orderByResourceType().list();
            AuthorizationQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceType().orderByResourceId().list();
            AuthorizationQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
    }

    public void testInvalidQueries() {
        try {
            this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"a"}).userIdIn(new String[]{"b"}).count();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot query for user and group authorizations at the same time.", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"b"}).groupIdIn(new String[]{"a"}).count();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot query for user and group authorizations at the same time.", e.getMessage());
        }
    }
}

