/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class RepositoryServiceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessInstanceById() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertNotNull((Object)processDefinition.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testFindProcessDefinitionById() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)definitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(((ProcessDefinition)definitions.get(0)).getId()).singleResult();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"The One Task Process", (String)processDefinition.getName());
        processDefinition = this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.get(0)).getId());
        RepositoryServiceTest.assertEquals((String)"This is a process for testing purposes", (String)processDefinition.getDescription());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        try {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            RepositoryServiceTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testDeleteDeploymentNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testDeleteDeploymentCascadeNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null, true);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentCascadeWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.deleteDeployment(processDefinition.getDeploymentId(), true);
    }

    public void testFindDeploymentResourceNamesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResourceNames(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testDeploymentWithDelayedProcessDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testDeploymentWithDelayedProcessDefinitionAndJobDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneAsyncTask.bpmn").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingResourceInExistingDeployment() {
        org.camunda.bpm.engine.repository.Deployment deployment = (org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        try {
            this.repositoryService.getResourceAsStream(deployment.getId(), "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingDeployment() {
        try {
            this.repositoryService.getResourceAsStream("unexistingdeployment", "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    public void testGetResourceAsStreamNullArguments() {
        try {
            this.repositoryService.getResourceAsStream(null, "resource");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
        try {
            this.repositoryService.getResourceAsStream("deployment", null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("resourceName is null", ae.getMessage());
        }
    }
}

