/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class TaskQueryTest
extends PluggableProcessEngineTestCase {
    private List<String> taskIds;

    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
        this.taskIds = this.generateTestTasks();
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
        this.taskService.deleteTasks(this.taskIds, true);
    }

    public void tesBasicTaskPropertiesNotNull() {
        Task task = (Task)this.taskService.createTaskQuery().taskId(this.taskIds.get(0)).singleResult();
        TaskQueryTest.assertNotNull((Object)task.getDescription());
        TaskQueryTest.assertNotNull((Object)task.getId());
        TaskQueryTest.assertNotNull((Object)task.getName());
        TaskQueryTest.assertNotNull((Object)task.getCreateTime());
    }

    public void testQueryNoCriteria() {
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId(this.taskIds.get(0));
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameLike("gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("1");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("testTask description");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescription(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("%gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescriptionLike(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByPriority() {
        TaskQuery query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(100));
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50));
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)9, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(3));
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
    }

    public void testQueryByInvalidPriority() {
        try {
            this.taskService.createTaskQuery().taskPriority(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByAssignee() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeLike("gonz%");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("gonz");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByNullAssignee() {
        try {
            this.taskService.createTaskQuery().taskAssignee(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByUnassigned() {
        TaskQuery query = this.taskService.createTaskQuery().taskUnassigned();
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
    }

    public void testQueryByCandidateUser() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie");
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCandidateUser() {
        try {
            this.taskService.createTaskQuery().taskCandidateUser(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroup() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroup("management");
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroup() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroup(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroupIn() {
        List<String> groups = Arrays.asList("management", "accountancy");
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        groups = Arrays.asList("management", "accountancy", "sales", "unexising");
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroupIn() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(new ArrayList()).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDelegationState() {
        TaskQuery query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        String taskId = ((Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult()).getId();
        this.taskService.delegateTask(taskId, "kermit");
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        this.taskService.resolveTask(taskId);
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
    }

    public void testQueryCreatedOn() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedOn(createTime);
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
    }

    public void testQueryCreatedBefore() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date before = sdf.parse("03/02/2002 02:02:02.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)7L, (long)query.count());
        TaskQueryTest.assertEquals((int)7, (int)query.list().size());
        before = sdf.parse("01/01/2001 01:01:01.000");
        query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryCreatedAfter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date after = sdf.parse("03/03/2003 03:03:03.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        after = sdf.parse("05/05/2005 05:05:05.000");
        query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("taskKey1").list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("taskKey1%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%123").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%Key12%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyLike("%unexistingKey%").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment
    public void testTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("unexistingVar", (Object)"value").count());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("booleanVar", (Object)false).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueCompare() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment
    public void testProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("booleanVar", (Object)false).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)928374L).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)928374L);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("taskVar", (Object)"theValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("longVar", (Object)928374L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().processVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueCompare() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionKey() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionKey("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionName() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionName("The One Task Process").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionName("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionNameLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionNameLike("The One Task%").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The One Task").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The Other Task%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKey("NON-EXISTING").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY%").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUZINESS-KEY%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueDate() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueDate(dueDate).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(otherDate.getTime()).count());
        Calendar priorDate = Calendar.getInstance();
        priorDate.setTime(dueDate);
        priorDate.roll(1, -1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(priorDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(otherDate.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueBefore() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueAfter() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((Object)followUpDate, (Object)((Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        otherDate.add(1, -2);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByActivityInstanceId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)processInstance;
        String activityInstanceId = execution.getActivityInstanceId();
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByMultipleActivityInstanceIds() throws Exception {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance1 instanceof ExecutionEntity));
        ExecutionEntity execution1 = (ExecutionEntity)processInstance1;
        String activityInstanceId1 = execution1.getActivityInstanceId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance2 instanceof ExecutionEntity));
        ExecutionEntity execution2 = (ExecutionEntity)processInstance2;
        String activityInstanceId2 = execution2.getActivityInstanceId();
        List result1 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1}).list();
        TaskQueryTest.assertEquals((int)1, (int)result1.size());
        TaskQueryTest.assertEquals((String)processInstance1.getId(), (String)((Task)result1.get(0)).getProcessInstanceId());
        List result2 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId2}).list();
        TaskQueryTest.assertEquals((int)1, (int)result2.size());
        TaskQueryTest.assertEquals((String)processInstance2.getId(), (String)((Task)result2.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((int)2, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByInvalidActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{"anInvalidActivityInstanceId"}).list().size());
    }

    public void testQueryPaging() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((int)11, (int)query.listPage(0, Integer.MAX_VALUE).size());
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(2, 2).size());
        TaskQueryTest.assertEquals((int)3, (int)query.listPage(4, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(10, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(10, 1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(-1, -1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(11, 2).size());
        TaskQueryTest.assertEquals((int)11, (int)query.listPage(0, 15).size());
    }

    public void testQuerySorting() {
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskPriority().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskDescription().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByProcessInstanceId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByExecutionId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByDueDate().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByFollowUpDate().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskPriority().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskDescription().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByProcessInstanceId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByExecutionId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByDueDate().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByFollowUpDate().desc()).list().size());
        TaskQueryTest.assertEquals((int)6, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").asc()).list().size());
        TaskQueryTest.assertEquals((int)6, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").desc()).list().size());
    }

    public void testNativeQuery() {
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).list().size());
        TaskQueryTest.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class))).count());
        TaskQueryTest.assertEquals((long)144L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM ACT_RU_TASK T1, ACT_RU_TASK T2")).count());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).count());
        List tasks = ((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"gonzoTask", (String)((Task)tasks.get(0)).getName());
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT DISTINCT T1.* FROM ACT_RU_TASK T1")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).count());
        TaskQueryTest.assertEquals((int)1, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = #{taskName}")).parameter("taskName", (Object)"gonzoTask")).count());
    }

    public void testNativeQueryPaging() {
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)5, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(0, 5).size());
        TaskQueryTest.assertEquals((int)2, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(10, 12).size());
    }

    private List<String> generateTestTasks() throws Exception {
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2001 01:01:01.000"));
        for (int i2 = 0; i2 < 6; ++i2) {
            Task task = this.taskService.newTask();
            task.setName("testTask");
            task.setDescription("testTask description");
            task.setPriority(3);
            this.taskService.saveTask(task);
            ids.add(task.getId());
            this.taskService.addCandidateUser(task.getId(), "kermit");
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("02/02/2002 02:02:02.000"));
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        task.setDescription("gonzo description");
        task.setPriority(4);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "gonzo");
        this.taskService.setVariable(task.getId(), "testVar", (Object)"someVariable");
        ids.add(task.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("03/03/2003 03:03:03.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("managementTask");
            task.setPriority(10);
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "management");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("04/04/2004 04:04:04.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("accountancyTask");
            task.setName("accountancy description");
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "accountancy");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("05/05/2005 05:05:05.000"));
        task = this.taskService.newTask();
        task.setName("managementAndAccountancyTask");
        this.taskService.saveTask(task);
        this.taskService.addCandidateGroup(task.getId(), "management");
        this.taskService.addCandidateGroup(task.getId(), "accountancy");
        ids.add(task.getId());
        return ids;
    }
}

