/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TaskVariablesTest
extends PluggableProcessEngineTestCase {
    public void testStandaloneTaskVariables() {
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.setVariable(taskId, "instrument", (Object)"trumpet");
        TaskVariablesTest.assertEquals((Object)"trumpet", (Object)this.taskService.getVariable(taskId, "instrument"));
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment
    public void testTaskExecutionVariables() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        this.runtimeService.setVariable(processInstanceId, "instrument", (Object)"trumpet");
        expectedVariables = new HashMap();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        this.taskService.setVariable(taskId, "player", (Object)"gonzo");
        expectedVariables = new HashMap();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        this.taskService.setVariableLocal(taskId, "budget", (Object)"unlimited");
        expectedVariables = new HashMap();
        expectedVariables.put("budget", "unlimited");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        expectedVariables = new HashMap();
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
    }
}

