/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class IntermediateTimerEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchingTimerEvent() throws Exception {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample");
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3005000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        IntermediateTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testExpression() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        variables1.put("dueDate", new Date());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("dueDate", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables2);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi2.getId()).count());
        List jobs = this.managementService.createJobQuery().executable().list();
        IntermediateTimerEventTest.assertEquals((int)2, (int)jobs.size());
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
        }
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi2.getId()).count());
        this.assertProcessEnded(pi1.getProcessInstanceId());
        this.assertProcessEnded(pi2.getProcessInstanceId());
    }
}

