/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.SignalCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingSuspensionTest
extends PluggableProcessEngineTestCase {
    static ControllableThread activeThread;

    @Deployment
    public void testCompetingSuspension() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("CompetingSuspensionProcess").singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("wait1").singleResult();
        SuspendProcessDefinitionThread suspensionThread = new SuspendProcessDefinitionThread(processDefinition.getId());
        suspensionThread.startAndWaitUntilControlIsReturned();
        SignalThread signalExecutionThread = new SignalThread(execution.getId());
        signalExecutionThread.startAndWaitUntilControlIsReturned();
        suspensionThread.proceedAndWaitTillDone();
        CompetingSuspensionTest.assertNull((Object)((Object)suspensionThread.exception));
        signalExecutionThread.proceedAndWaitTillDone();
        CompetingSuspensionTest.assertNotNull((Object)((Object)signalExecutionThread.exception));
    }

    class SignalThread
    extends ControllableThread {
        private String executionId;
        OptimisticLockingException exception;

        public SignalThread(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSuspensionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)new SignalCmd(this.executionId, null, null, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }

    class SuspendProcessDefinitionThread
    extends ControllableThread {
        private String processDefinitionId;
        OptimisticLockingException exception;

        public SuspendProcessDefinitionThread(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSuspensionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)new SuspendProcessDefinitionCmd(this.processDefinitionId, null, true, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

