/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.executionlistener;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class RecorderExecutionListener
implements ExecutionListener {
    private FixedValue parameter;
    private static List<RecordedEvent> recordedEvents = new ArrayList<RecordedEvent>();

    public void notify(DelegateExecution execution) throws Exception {
        ExecutionEntity executionCasted = (ExecutionEntity)execution;
        recordedEvents.add(new RecordedEvent(executionCasted.getActivityId(), (String)executionCasted.getActivity().getProperties().get("name"), execution.getEventName(), (String)this.parameter.getValue((VariableScope)execution)));
    }

    public static void clear() {
        recordedEvents.clear();
    }

    public static List<RecordedEvent> getRecordedEvents() {
        return recordedEvents;
    }

    public static class RecordedEvent {
        private final String activityId;
        private final String eventName;
        private final String activityName;
        private final String parameter;

        public RecordedEvent(String activityId, String activityName, String eventName, String parameter) {
            this.activityId = activityId;
            this.activityName = activityName;
            this.parameter = parameter;
            this.eventName = eventName;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public String getParameter() {
            return this.parameter;
        }
    }
}

