/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.tasklistener;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CustomTaskAssignmentTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("kermit", "management");
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteGroup("management");
        super.tearDown();
    }

    @Deployment
    public void testCandidateGroupAssignment() {
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment");
        CustomTaskAssignmentTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup("management").count());
        CustomTaskAssignmentTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("kermit").count());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateUser("fozzie").count());
    }

    @Deployment
    public void testCandidateUserAssignment() {
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment");
        CustomTaskAssignmentTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("kermit").count());
        CustomTaskAssignmentTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("fozzie").count());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateUser("gonzo").count());
    }

    @Deployment
    public void testAssigneeAssignment() {
        this.runtimeService.startProcessInstanceByKey("setAssigneeInListener");
        CustomTaskAssignmentTest.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("gonzo").count());
    }

    @Deployment
    public void testOverwriteExistingAssignments() {
        this.runtimeService.startProcessInstanceByKey("overrideAssigneeInListener");
        CustomTaskAssignmentTest.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("gonzo").count());
    }

    @Deployment
    public void testOverwriteExistingAssignmentsFromVariable() {
        HashMap<String, String> assigneeMappingTable = new HashMap<String, String>();
        assigneeMappingTable.put("fozzie", "gonzo");
        HashMap<String, HashMap<String, String>> variables = new HashMap<String, HashMap<String, String>>();
        variables.put("assigneeMappingTable", assigneeMappingTable);
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment", variables);
        CustomTaskAssignmentTest.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        CustomTaskAssignmentTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("kermit").count());
    }

    @Deployment
    public void testReleaseTask() throws Exception {
        this.runtimeService.startProcessInstanceByKey("releaseTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("fozzie").singleResult();
        CustomTaskAssignmentTest.assertNotNull((Object)task);
        String taskId = task.getId();
        this.taskService.setAssignee(taskId, null);
        task = (Task)this.taskService.createTaskQuery().taskAssignee("fozzie").singleResult();
        CustomTaskAssignmentTest.assertNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        CustomTaskAssignmentTest.assertNotNull((Object)task);
        CustomTaskAssignmentTest.assertNull((Object)task.getAssignee());
    }
}

