/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.mgmt;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.TableMetaData;

public class ManagementServiceTest
extends PluggableProcessEngineTestCase {
    public void testTableCount() {
        Map tableCount = this.managementService.getTableCount();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        ManagementServiceTest.assertEquals((Object)new Long(4L), tableCount.get(tablePrefix + "ACT_GE_PROPERTY"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_GE_BYTEARRAY"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RE_DEPLOYMENT"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_EXECUTION"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_GROUP"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_MEMBERSHIP"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_ID_USER"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RE_PROCDEF"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_TASK"));
        ManagementServiceTest.assertEquals((Object)new Long(0L), tableCount.get(tablePrefix + "ACT_RU_IDENTITYLINK"));
    }

    public void testGetTableMetaData() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TableMetaData tableMetaData = this.managementService.getTableMetaData(tablePrefix + "ACT_RU_TASK");
        ManagementServiceTest.assertEquals((int)tableMetaData.getColumnNames().size(), (int)tableMetaData.getColumnTypes().size());
        ManagementServiceTest.assertEquals((int)17, (int)tableMetaData.getColumnNames().size());
        int assigneeIndex = tableMetaData.getColumnNames().indexOf("ASSIGNEE_");
        int createTimeIndex = tableMetaData.getColumnNames().indexOf("CREATE_TIME_");
        ManagementServiceTest.assertTrue((assigneeIndex >= 0 ? 1 : 0) != 0);
        ManagementServiceTest.assertTrue((createTimeIndex >= 0 ? 1 : 0) != 0);
        this.assertOneOf(new String[]{"VARCHAR", "NVARCHAR2", "nvarchar", "NVARCHAR"}, (String)tableMetaData.getColumnTypes().get(assigneeIndex));
        this.assertOneOf(new String[]{"TIMESTAMP", "TIMESTAMP(6)", "datetime", "DATETIME", "DATETIME2"}, (String)tableMetaData.getColumnTypes().get(createTimeIndex));
    }

    private void assertOneOf(String[] possibleValues, String currentValue) {
        for (String value : possibleValues) {
            if (!currentValue.equals(value)) continue;
            return;
        }
        ManagementServiceTest.fail((String)("Value '" + currentValue + "' should be one of: " + Arrays.deepToString(possibleValues)));
    }
}

