/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.SerializableVariable;

public class VariablesTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testBasicVariableOperations() {
        Date now = new Date();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        byte[] bytes = "somebytes".getBytes();
        Map variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", now);
        variables.put("nullVar", null);
        variables.put("serializableVar", serializable);
        variables.put("bytesVar", bytes);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals((Object)928374L, variables.get("longVar"));
        VariablesTest.assertEquals((Object)123, variables.get("shortVar"));
        VariablesTest.assertEquals((Object)1234, variables.get("integerVar"));
        VariablesTest.assertEquals((Object)"coca-cola", variables.get("stringVar"));
        VariablesTest.assertEquals((Object)now, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(serializable, variables.get("serializableVar"));
        VariablesTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        VariablesTest.assertEquals((int)8, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", null);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals(null, variables.get("longVar"));
        VariablesTest.assertEquals(null, variables.get("shortVar"));
        VariablesTest.assertEquals(null, variables.get("integerVar"));
        VariablesTest.assertEquals(null, variables.get("stringVar"));
        VariablesTest.assertEquals(null, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(null, variables.get("serializableVar"));
        VariablesTest.assertEquals(null, variables.get("bytesVar"));
        VariablesTest.assertEquals((int)8, (int)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "new var", (Object)"hi");
        this.runtimeService.setVariable(processInstance.getId(), "longVar", (Object)9987L);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", (Object)456);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", (Object)4567);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", (Object)"colgate");
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", (Object)now);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", (Object)bytes);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals((Object)"hi", variables.get("new var"));
        VariablesTest.assertEquals((Object)9987L, variables.get("longVar"));
        VariablesTest.assertEquals((Object)456, variables.get("shortVar"));
        VariablesTest.assertEquals((Object)4567, variables.get("integerVar"));
        VariablesTest.assertEquals((Object)"colgate", variables.get("stringVar"));
        VariablesTest.assertEquals((Object)now, variables.get("dateVar"));
        VariablesTest.assertEquals(null, variables.get("nullVar"));
        VariablesTest.assertEquals(serializable, variables.get("serializableVar"));
        VariablesTest.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        VariablesTest.assertEquals((int)9, (int)variables.size());
        ArrayList<String> varFilter = new ArrayList<String>(2);
        varFilter.add("stringVar");
        varFilter.add("integerVar");
        Map filteredVariables = this.runtimeService.getVariables(processInstance.getId(), varFilter);
        VariablesTest.assertEquals((int)2, (int)filteredVariables.size());
        VariablesTest.assertTrue((boolean)filteredVariables.containsKey("stringVar"));
        VariablesTest.assertTrue((boolean)filteredVariables.containsKey("integerVar"));
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", (Object)"a value");
        Object newValue = this.runtimeService.getVariable(processInstance.getId(), "nullVar");
        VariablesTest.assertNotNull((Object)newValue);
        VariablesTest.assertEquals((Object)"a value", (Object)newValue);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", (Object)100);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals((Object)100, variables.get("serializableVar"));
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        variables = this.runtimeService.getVariables(processInstance.getId());
        VariablesTest.assertEquals(serializable, variables.get("serializableVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/variables/VariablesTest.testBasicVariableOperations.bpmn20.xml"})
    public void testOnlyChangeType() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("aVariable", 1234);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"integer", (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234L);
        variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"long", (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234);
        variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"short", (String)variable.getTypeName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/variables/VariablesTest.testBasicVariableOperations.bpmn20.xml"})
    public void testChangeTypeFromSerializableUsingApi() {
        HashMap<String, SerializableVariable> variables = new HashMap<String, SerializableVariable>();
        variables.put("aVariable", new SerializableVariable("foo"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"serializable", (String)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", null);
        variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"null", (String)variable.getTypeName());
    }

    @Deployment
    public void testChangeSerializableInsideEngine() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        SerializableVariable var = (SerializableVariable)this.taskService.getVariable(task.getId(), "variableName");
        VariablesTest.assertNotNull((Object)var);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/variables/VariablesTest.testBasicVariableOperations.bpmn20.xml"})
    public void testChangeToSerializableUsingApi() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"string", (String)variable.getTypeName());
        this.runtimeService.setVariable(processInstance.getId(), "aVariable", (Object)new SerializableVariable("foo"));
        variable = (VariableInstance)query.singleResult();
        VariablesTest.assertEquals((String)"serializable", (String)variable.getTypeName());
    }
}

