/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricActivityInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testHistoricActivityInstanceNoop() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noopProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"noop", (String)historicActivityInstance.getActivityId());
        HistoricActivityInstanceTest.assertEquals((String)"serviceTask", (String)historicActivityInstance.getActivityType());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getProcessInstanceId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getExecutionId());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getEndTime());
        HistoricActivityInstanceTest.assertTrue((historicActivityInstance.getDurationInMillis() >= 0L ? 1 : 0) != 0);
    }

    @Deployment
    public void testHistoricActivityInstanceReceive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"receive", (String)historicActivityInstance.getActivityId());
        HistoricActivityInstanceTest.assertEquals((String)"receiveTask", (String)historicActivityInstance.getActivityType());
        HistoricActivityInstanceTest.assertNull((Object)historicActivityInstance.getEndTime());
        HistoricActivityInstanceTest.assertNull((Object)historicActivityInstance.getDurationInMillis());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getProcessInstanceId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getExecutionId());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        Date now = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 1000L));
        this.runtimeService.signal(processInstance.getId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"receive", (String)historicActivityInstance.getActivityId());
        HistoricActivityInstanceTest.assertEquals((String)"receiveTask", (String)historicActivityInstance.getActivityType());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getEndTime());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getProcessInstanceId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getExecutionId());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        HistoricActivityInstanceTest.assertTrue((historicActivityInstance.getDurationInMillis() >= 1000L ? 1 : 0) != 0);
        HistoricActivityInstanceTest.assertTrue((((HistoricActivityInstanceEventEntity)historicActivityInstance).getDurationRaw() >= 1000L ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceReceive.bpmn20.xml"})
    public void testLongRunningHistoricActivityInstanceReceive() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        ClockUtil.setCurrentTime((Date)cal.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"receive", (String)historicActivityInstance.getActivityId());
        HistoricActivityInstanceTest.assertEquals((String)"receiveTask", (String)historicActivityInstance.getActivityType());
        HistoricActivityInstanceTest.assertNull((Object)historicActivityInstance.getEndTime());
        HistoricActivityInstanceTest.assertNull((Object)historicActivityInstance.getDurationInMillis());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getProcessInstanceId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getExecutionId());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        cal.add(1, 1);
        ClockUtil.setCurrentTime((Date)cal.getTime());
        this.runtimeService.signal(processInstance.getId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("receive").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"receive", (String)historicActivityInstance.getActivityId());
        HistoricActivityInstanceTest.assertEquals((String)"receiveTask", (String)historicActivityInstance.getActivityType());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getEndTime());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getProcessDefinitionId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getProcessInstanceId());
        HistoricActivityInstanceTest.assertEquals((String)processInstance.getId(), (String)historicActivityInstance.getExecutionId());
        HistoricActivityInstanceTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        HistoricActivityInstanceTest.assertTrue((historicActivityInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        HistoricActivityInstanceTest.assertTrue((((HistoricActivityInstanceEventEntity)historicActivityInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
    }

    @Deployment
    public void testHistoricActivityInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noopProcess");
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("nonExistingActivityId").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").list().size());
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().activityType("nonExistingActivityType").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityType("serviceTask").list().size());
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().activityName("nonExistingActivityName").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityName("No operation").list().size());
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().taskAssignee("nonExistingAssignee").list().size());
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().executionId("nonExistingExecutionId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            HistoricActivityInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricActivityInstanceQuery().executionId(processInstance.getId()).list().size());
        } else {
            HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().executionId(processInstance.getId()).list().size());
        }
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().processInstanceId("nonExistingProcessInstanceId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            HistoricActivityInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        } else {
            HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        }
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId("nonExistingProcessDefinitionId").list().size());
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            HistoricActivityInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list().size());
        } else {
            HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list().size());
        }
        HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().unfinished().list().size());
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            HistoricActivityInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricActivityInstanceQuery().finished().list().size());
        } else {
            HistoricActivityInstanceTest.assertEquals((int)0, (int)this.historyService.createHistoricActivityInstanceQuery().finished().list().size());
        }
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().list().get(0);
            HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicActivityInstance.getId()).list().size());
        }
    }

    @Deployment
    public void testHistoricActivityInstanceForEventsQuery() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("eventProcess");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.signalEventReceived("signal");
        this.assertProcessEnded(pi.getId());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("noop").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("intermediate-event").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("start").list().size());
        HistoricActivityInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricActivityInstanceQuery().activityId("end").list().size());
        HistoricActivityInstance intermediateEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("intermediate-event").singleResult();
        HistoricActivityInstanceTest.assertNotNull((Object)intermediateEvent.getStartTime());
        HistoricActivityInstanceTest.assertNotNull((Object)intermediateEvent.getEndTime());
        HistoricActivityInstance startEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("start").singleResult();
        HistoricActivityInstanceTest.assertNotNull((Object)startEvent.getStartTime());
        HistoricActivityInstanceTest.assertNotNull((Object)startEvent.getEndTime());
        HistoricActivityInstance endEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("end").singleResult();
        HistoricActivityInstanceTest.assertNotNull((Object)endEvent.getStartTime());
        HistoricActivityInstanceTest.assertNotNull((Object)endEvent.getEndTime());
    }

    @Deployment
    public void testHistoricActivityInstanceProperties() {
        this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricActivityInstanceTest.assertEquals((String)task.getId(), (String)historicActivityInstance.getTaskId());
        HistoricActivityInstanceTest.assertEquals((String)"kermit", (String)historicActivityInstance.getAssignee());
        this.taskService.setAssignee(task.getId(), "gonzo");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"gonzo", (String)historicActivityInstance.getAssignee());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/calledProcess.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testCallSimpleSubProcess.bpmn20.xml"})
    public void testHistoricActivityInstanceCalledProcessId() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("callSubProcess").singleResult();
        HistoricProcessInstance oldInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("calledProcess").singleResult();
        HistoricActivityInstanceTest.assertEquals((String)oldInstance.getId(), (String)historicActivityInstance.getCalledProcessInstanceId());
    }

    @Deployment
    public void testSorting() {
        this.runtimeService.startProcessInstanceByKey("process");
        int expectedActivityInstances = -1;
        expectedActivityInstances = this.processEngineConfiguration.getHistoryLevel() >= 1 ? 2 : 0;
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((int)expectedActivityInstances, (int)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceId().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByExecutionId().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessDefinitionId().desc()).count());
        HistoricActivityInstanceTest.assertEquals((long)expectedActivityInstances, (long)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByProcessInstanceId().desc()).count());
    }

    public void testInvalidSorting() {
        try {
            ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().asc()).list();
            HistoricActivityInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().desc()).list();
            HistoricActivityInstanceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceDuration().list();
            HistoricActivityInstanceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricActivityInstanceQueryStartFinishAfterBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey123");
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourFromNow.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourFromNow.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedBefore(hourFromNow.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedBefore(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedAfter(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").startedAfter(hourFromNow.getTime()).count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finished().count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedBefore(hourFromNow.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourAgo.getTime()).count());
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").finishedAfter(hourFromNow.getTime()).count());
    }

    @Deployment
    public void testHistoricActivityInstanceQueryByCompleteScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().completeScope();
        HistoricActivityInstanceTest.assertEquals((long)3L, (long)query.count());
        List instances = query.list();
        for (HistoricActivityInstance instance : instances) {
            if (instance.getActivityId().equals("innerEnd") || instance.getActivityId().equals("end1") || instance.getActivityId().equals("end2")) continue;
            HistoricActivityInstanceTest.fail((String)("Unexpected instance with activity id " + instance.getActivityId() + " found."));
        }
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceQueryByCompleteScope.bpmn"})
    public void testHistoricActivityInstanceQueryByCanceled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().canceled();
        HistoricActivityInstanceTest.assertEquals((long)3L, (long)query.count());
        List instances = query.list();
        for (HistoricActivityInstance instance : instances) {
            if (instance.getActivityId().equals("subprocess") || instance.getActivityId().equals("userTask1") || instance.getActivityId().equals("userTask2")) continue;
            HistoricActivityInstanceTest.fail((String)("Unexpected instance with activity id " + instance.getActivityId() + " found."));
        }
        this.assertProcessEnded(processInstance.getId());
    }

    public void testHistoricActivityInstanceQueryByCompleteScopeAndCanceled() {
        try {
            this.historyService.createHistoricActivityInstanceQuery().completeScope().canceled().list();
            HistoricActivityInstanceTest.fail((String)"It should not be possible to query by completeScope and canceled.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testHistoricActivityInstanceGatewayEndTimes() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("gatewayEndTimes");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult()).getEndTime());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("Gateway_0").singleResult()).getEndTime());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("Gateway_1");
        HistoricActivityInstanceTest.assertEquals((long)2L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.list().get(0)).getEndTime());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.list().get(1)).getEndTime());
    }

    @Deployment
    public void testHistoricActivityInstanceTimerEvent() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)jobQuery.count());
        Job timer = (Job)jobQuery.singleResult();
        this.managementService.executeJob(timer.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"afterTimer", (String)task.getName());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("gw1");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("timerEvent");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceTimerEvent.bpmn20.xml"})
    public void testHistoricActivityInstanceMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        JobQuery jobQuery = this.managementService.createJobQuery();
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)jobQuery.count());
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)eventSubscriptionQuery.count());
        this.runtimeService.correlateMessage("newInvoice");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.singleResult();
        HistoricActivityInstanceTest.assertEquals((String)"afterMessage", (String)task.getName());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("gw1");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("messageEvent");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
    }

    @Deployment
    public void testUserTaskStillRunning() {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingEvent");
        JobQuery jobQuery = this.managementService.createJobQuery();
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)jobQuery.singleResult()).getId());
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("userTask");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("end1");
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)historicActivityInstanceQuery.count());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("timer");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
        historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().activityId("end2");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)historicActivityInstanceQuery.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)historicActivityInstanceQuery.singleResult()).getEndTime());
    }

    @Deployment
    public void testInterruptingBoundaryMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        this.runtimeService.messageEventReceived("newMessage", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("message");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNonInterruptingBoundaryMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        this.runtimeService.messageEventReceived("newMessage", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("message");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testInterruptingBoundarySignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("newSignal").singleResult();
        this.runtimeService.signalEventReceived("newSignal", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("signal");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNonInterruptingBoundarySignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("newSignal").singleResult();
        this.runtimeService.signalEventReceived("newSignal", execution.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("signal");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testInterruptingBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricActivityInstanceTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("timer");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNonInterruptingBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricActivityInstanceTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("timer");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testBoundaryErrorEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("error");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testBoundaryCancelEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("catchCancel");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testBoundaryCompensateEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("compensate");
        HistoricActivityInstanceTest.assertEquals((long)0L, (long)query.count());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testBoundaryCompensateEvent.bpmn20.xml"})
    public void FAILING_testCompensationServiceTaskHasEndTime() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("compensationServiceTask");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testBoundaryCancelEvent.bpmn20.xml"})
    public void testTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("transaction");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstanceTest.assertNotNull((Object)((HistoricActivityInstance)query.singleResult()).getEndTime());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testScopeActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("userTask");
        HistoricActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)query.singleResult();
        HistoricActivityInstanceTest.assertEquals((String)pi.getId(), (String)historicActivityInstance.getParentActivityInstanceId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultiInstanceScopeActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("userTask");
        HistoricActivityInstanceTest.assertEquals((long)5L, (long)query.count());
        List result = query.list();
        for (HistoricActivityInstance instance : result) {
            HistoricActivityInstanceTest.assertEquals((String)pi.getId(), (String)instance.getParentActivityInstanceId());
        }
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultiInstanceReceiveActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        query.activityId("receiveTask");
        HistoricActivityInstanceTest.assertEquals((long)5L, (long)query.count());
        List result = query.list();
        for (HistoricActivityInstance instance : result) {
            HistoricActivityInstanceTest.assertEquals((String)pi.getId(), (String)instance.getParentActivityInstanceId());
        }
    }
}

