/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public abstract class HistoryLevelTest
extends PluggableProcessEngineTestCase {
    private ProcessInstance startProcessAndCompleteUserTask() {
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("HistoryLevelTest");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "icke");
        this.taskService.complete(task.getId());
        return process;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testLevelNone() {
        this.processEngineConfiguration.setHistoryLevel(0);
        ProcessInstance process = this.startProcessAndCompleteUserTask();
        this.assertProcessEnded(process.getId());
        HistoryLevelTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testLevelActivity() {
        this.processEngineConfiguration.setHistoryLevel(1);
        ProcessInstance process = this.startProcessAndCompleteUserTask();
        this.assertProcessEnded(process.getId());
        HistoryLevelTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testLevelAudit() {
        this.processEngineConfiguration.setHistoryLevel(2);
        ProcessInstance process = this.startProcessAndCompleteUserTask();
        this.assertProcessEnded(process.getId());
        HistoryLevelTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void testLevelFull() {
        this.processEngineConfiguration.setHistoryLevel(3);
        ProcessInstance process = this.startProcessAndCompleteUserTask();
        this.assertProcessEnded(process.getId());
        HistoryLevelTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoryLevelTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
    }
}

