/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class JobDefinitionDeploymentTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testTimerStartEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-start-event", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theStart", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        Job timerStartJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionDeploymentTest.assertEquals((String)jobDefinition.getId(), (String)timerStartJob.getJobDefinitionId());
    }

    @Deployment
    public void testTimerBoundaryEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testMultipleTimerBoundaryEvents() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").list();
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)jobDefinitions.size());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitions.get(0);
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent1", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DATE: 2036-11-14T11:12:22", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitions.get(1);
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theBoundaryEvent2", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testEventBasedGateway() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").list();
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)jobDefinitions.size());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitions.get(0);
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer1", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitions.get(1);
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer2", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT10M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testTimerIntermediateEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"timer-intermediate-transition", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"timer", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals((String)"DURATION: PT5M", (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    public void testAsyncContinuation() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        JobDefinitionDeploymentTest.assertEquals((String)"async-continuation", (String)jobDefinition.getJobType());
        JobDefinitionDeploymentTest.assertEquals((String)"theService", (String)jobDefinition.getActivityId());
        JobDefinitionDeploymentTest.assertEquals(null, (String)jobDefinition.getJobConfiguration());
        JobDefinitionDeploymentTest.assertEquals((String)processDefinition.getId(), (String)jobDefinition.getProcessDefinitionId());
    }

    public void testTimerStartEventRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerStartEvent.bpmn20.xml").deploy().getId();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionDeploymentTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testTimerBoundaryEventRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerBoundaryEvent.bpmn20.xml").deploy().getId();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobDefinitionDeploymentTest.assertNotNull((Object)jobDefinition);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((String)jobDefinition.getId(), (String)((JobDefinition)this.managementService.createJobDefinitionQuery().singleResult()).getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionDeploymentTest.assertEquals((String)jobDefinition.getId(), (String)job.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testMultipleTimerBoundaryEventsRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testMultipleTimerBoundaryEvents.bpmn20.xml").deploy().getId();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)jobDefinitions.size());
        Set<String> definitionIds = this.getJobDefinitionIds(jobDefinitions);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)2L, (long)this.managementService.createJobDefinitionQuery().count());
        List jobs = this.managementService.createJobQuery().list();
        JobDefinitionDeploymentTest.assertFalse((String)"Both jobs were created from different job definitions", (boolean)((Job)jobs.get(0)).getJobDefinitionId().equals(((Job)jobs.get(1)).getJobDefinitionId()));
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(0)).getJobDefinitionId()));
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(1)).getJobDefinitionId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testEventBasedGatewayRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testEventBasedGateway.bpmn20.xml").deploy().getId();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)jobDefinitions.size());
        Set<String> definitionIds = this.getJobDefinitionIds(jobDefinitions);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)2L, (long)this.managementService.createJobDefinitionQuery().count());
        List jobs = this.managementService.createJobQuery().list();
        JobDefinitionDeploymentTest.assertFalse((String)"Both jobs were created from different job definitions", (boolean)((Job)jobs.get(0)).getJobDefinitionId().equals(((Job)jobs.get(1)).getJobDefinitionId()));
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(0)).getJobDefinitionId()));
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(1)).getJobDefinitionId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testTimerIntermediateEventRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerIntermediateEvent.bpmn20.xml").deploy().getId();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        JobDefinitionDeploymentTest.assertEquals((int)1, (int)jobDefinitions.size());
        Set<String> definitionIds = this.getJobDefinitionIds(jobDefinitions);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        List jobs = this.managementService.createJobQuery().list();
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(0)).getJobDefinitionId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void testAsyncContinuatioRedeployment() {
        JobDefinitionDeploymentTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuation.bpmn20.xml").deploy().getId();
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        JobDefinitionDeploymentTest.assertEquals((int)1, (int)jobDefinitions.size());
        Set<String> definitionIds = this.getJobDefinitionIds(jobDefinitions);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobDefinitionDeploymentTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        List jobs = this.managementService.createJobQuery().list();
        JobDefinitionDeploymentTest.assertTrue((boolean)definitionIds.contains(((Job)jobs.get(0)).getJobDefinitionId()));
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuation.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testMultipleProcessesWithinDeployment.bpmn20.xml"})
    public void testMultipleProcessDeployment() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        List jobDefinitions = query.list();
        JobDefinitionDeploymentTest.assertEquals((int)3, (int)jobDefinitions.size());
        JobDefinitionDeploymentTest.assertEquals((int)1, (int)query.processDefinitionKey("testProcess").list().size());
        JobDefinitionDeploymentTest.assertEquals((int)2, (int)query.processDefinitionKey("anotherTestProcess").list().size());
    }

    protected Set<String> getJobDefinitionIds(List<JobDefinition> jobDefinitions) {
        HashSet<String> definitionIds = new HashSet<String>();
        for (JobDefinition definition : jobDefinitions) {
            definitionIds.add(definition.getId());
        }
        return definitionIds;
    }
}

