/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.cmd.DeleteJobCmd;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.jobexecutor.TweetExceptionHandler;

public class JobExecutorCmdExceptionTest
extends PluggableProcessEngineTestCase {
    protected TweetExceptionHandler tweetExceptionHandler = new TweetExceptionHandler();

    public void setUp() throws Exception {
        this.processEngineConfiguration.getJobHandlers().put(this.tweetExceptionHandler.getType(), this.tweetExceptionHandler);
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.getJobHandlers().remove(this.tweetExceptionHandler.getType());
        this.clearDatabase();
    }

    public void testJobCommandsWith2Exceptions() {
        this.createJob();
        this.executeAvailableJobs();
        JobQuery query = this.managementService.createJobQuery().noRetriesLeft();
        JobExecutorCmdExceptionTest.assertEquals((long)0L, (long)query.count());
    }

    public void testJobCommandsWith3Exceptions() {
        this.tweetExceptionHandler.setExceptionsRemaining(3);
        this.createJob();
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().noRetriesLeft().singleResult();
        JobExecutorCmdExceptionTest.assertNotNull((Object)job);
        JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
    }

    public void testMultipleFailingJobs() {
        this.tweetExceptionHandler.setExceptionsRemaining(600);
        for (int i = 0; i < 40; ++i) {
            this.createJob();
        }
        this.executeAvailableJobs();
        List jobList = this.managementService.createJobQuery().list();
        JobExecutorCmdExceptionTest.assertEquals((int)40, (int)jobList.size());
        for (Job job : jobList) {
            JobExecutorCmdExceptionTest.assertEquals((int)0, (int)job.getRetries());
        }
    }

    protected void createJob() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdExceptionTest.this.createTweetExceptionMessage();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
    }

    protected MessageEntity createTweetExceptionMessage() {
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType("tweet-exception");
        return message;
    }

    protected void clearDatabase() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getManagementService().createJobQuery().list();
                for (Job job : jobs) {
                    new DeleteJobCmd(job.getId()).execute(commandContext);
                }
                List historicIncidents = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbSqlSession().delete((PersistentObject)historicIncident);
                }
                return null;
            }
        });
    }
}

