/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.serializable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Date;
import junit.framework.TestCase;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessElement;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessElementImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.test.serializable.TestExecutionListener;

public class ObjectSerializableTest
extends TestCase {
    public void testTaskEntitySerialization() throws Exception {
        TaskEntity task = new TaskEntity();
        task.setDelegationState(DelegationState.RESOLVED);
        task.setExecution(new ExecutionEntity());
        task.setProcessInstance(new ExecutionEntity());
        task.setTaskDefinition(new TaskDefinition(null));
        task.setAssignee("kermit");
        task.setCreateTime(new Date());
        task.setDescription("Test description");
        task.setDueDate(new Date());
        task.setName("myTask");
        task.setEventName("end");
        task.setDeleted(false);
        task.setDelegationStateString(DelegationState.RESOLVED.name());
        byte[] data = this.writeObject(task);
        task = (TaskEntity)this.readObject(data);
        ObjectSerializableTest.assertEquals((String)"kermit", (String)task.getAssignee());
        ObjectSerializableTest.assertEquals((String)"myTask", (String)task.getName());
        ObjectSerializableTest.assertEquals((String)"end", (String)task.getEventName());
    }

    public void testExecutionEntitySerialization() throws Exception {
        ExecutionEntity execution = new ExecutionEntity();
        ActivityImpl activityImpl = new ActivityImpl("test", null);
        activityImpl.getExecutionListeners().put("start", Collections.singletonList(new TestExecutionListener()));
        execution.setActivity((PvmActivity)activityImpl);
        ProcessDefinitionImpl processDefinitionImpl = new ProcessDefinitionImpl("test");
        processDefinitionImpl.getExecutionListeners().put("start", Collections.singletonList(new TestExecutionListener()));
        execution.setProcessDefinition(processDefinitionImpl);
        TransitionImpl transitionImpl = new TransitionImpl("test", new ProcessDefinitionImpl("test"));
        transitionImpl.addExecutionListener((ExecutionListener)new TestExecutionListener());
        execution.setTransition(transitionImpl);
        execution.setTransitionBeingTaken(transitionImpl);
        execution.getProcessInstanceStartContext().setInitial(activityImpl);
        execution.setSuperExecution(new ExecutionEntity());
        ProcessElementImpl processElementImpl = new ProcessElementImpl("test", processDefinitionImpl);
        processElementImpl.setProperty("myProperty", (Object)"myPropertyValue");
        execution.setEventSource((PvmProcessElement)processElementImpl);
        execution.setActive(true);
        execution.setCanceled(false);
        execution.setBusinessKey("myBusinessKey");
        execution.setDeleteReason("no reason");
        execution.setActivityInstanceId("123");
        execution.setScope(false);
        byte[] data = this.writeObject(execution);
        execution = (ExecutionEntity)this.readObject(data);
        ObjectSerializableTest.assertEquals((String)"myBusinessKey", (String)execution.getBusinessKey());
        ObjectSerializableTest.assertEquals((String)"no reason", (String)execution.getDeleteReason());
        ObjectSerializableTest.assertEquals((String)"123", (String)execution.getActivityInstanceId());
    }

    private byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
        outputStream.writeObject(object);
        outputStream.flush();
        outputStream.close();
        return buffer.toByteArray();
    }

    private Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        ObjectInputStream inputStream = new ObjectInputStream(buffer);
        Object object = inputStream.readObject();
        return object;
    }
}

