/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.scripting.ScriptingEngines;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected final String script;
    protected final String language;
    protected final String resultVariable;

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable) {
        this.script = script;
        this.language = language;
        this.resultVariable = resultVariable;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        boolean noErrors = true;
        try {
            Object result = scriptingEngines.evaluate(this.script, this.language, execution);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ProcessEngineException e) {
            noErrors = false;
            if (e.getCause() instanceof ScriptException && e.getCause().getCause() instanceof ScriptException && e.getCause().getCause().getCause() instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)e.getCause().getCause().getCause(), execution);
            }
            ErrorPropagation.propagateException(e, execution);
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

