/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, Object> variables;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables) {
        this.taskId = taskId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        if (this.variables != null) {
            task.setExecutionVariables(this.variables);
        }
        this.completeTask(task);
        return null;
    }

    protected void completeTask(TaskEntity task) {
        task.complete();
    }
}

