/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class GetExecutionVariablesCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        Map<String, Object> executionVariables = this.isLocal ? execution.getVariablesLocal() : execution.getVariables();
        if (this.variableNames != null && this.variableNames.size() > 0) {
            HashMap<String, Object> tempVariables = new HashMap<String, Object>();
            for (String variableName : this.variableNames) {
                if (!executionVariables.containsKey(variableName)) continue;
                tempVariables.put(variableName, executionVariables.get(variableName));
            }
            executionVariables = tempVariables;
        }
        return executionVariables;
    }
}

