/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ibatis.session.SqlSession;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.GroupQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.db.upgrade.DbUpgradeStep;
import org.camunda.bpm.engine.impl.identity.db.DbGroupQueryImpl;
import org.camunda.bpm.engine.impl.identity.db.DbUserQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.variable.DeserializedObject;

public class DbSqlSession
implements Session {
    private static Logger log = Logger.getLogger(DbSqlSession.class.getName());
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected List<PersistentObject> insertedObjects = new ArrayList<PersistentObject>();
    protected List<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
    protected Map<Class<?>, Map<String, CachedObject>> cachedObjects = new HashMap();
    protected List<BulkUpdateOperation> bulkUpdates = new ArrayList<BulkUpdateOperation>();
    protected List<DeleteOperation> deleteOperations = new ArrayList<DeleteOperation>();
    protected List<DeserializedObject> deserializedObjects = new ArrayList<DeserializedObject>();
    protected String connectionMetadataDefaultCatalog = null;
    protected String connectionMetadataDefaultSchema = null;
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insertAt(PersistentObject persistentObject, int index) {
        if (persistentObject.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            persistentObject.setId(id);
        }
        if (index == -1) {
            index = this.insertedObjects.size();
        }
        this.insertedObjects.add(index, persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void insert(PersistentObject persistentObject) {
        this.insertAt(persistentObject, -1);
    }

    public void insertBefore(PersistentObject objectToInsert, PersistentObject referenceObject) {
        int index = this.insertedObjects.indexOf(referenceObject);
        this.insertAt(objectToInsert, index);
    }

    public void update(PersistentObject persistentObject) {
        this.updatedObjects.add(persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void delete(String statement, Object parameter) {
        this.deleteOperations.add(new BulkDeleteOperation(statement, parameter));
    }

    public void update(String statement, Object parameter) {
        BulkUpdateOperation updateOperation = new BulkUpdateOperation(statement, parameter);
        this.bulkUpdates.add(updateOperation);
    }

    public void delete(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!(deleteOperation instanceof DeletePersistentObjectOperation)) continue;
            DeletePersistentObjectOperation deletePersistentObjectOperation = (DeletePersistentObjectOperation)deleteOperation;
            if (!persistentObject.getId().equals(deletePersistentObjectOperation.getPersistentObject().getId()) || !persistentObject.getClass().equals(deletePersistentObjectOperation.getPersistentObject().getClass())) continue;
            return;
        }
        this.deleteOperations.add(new DeletePersistentObjectOperation(persistentObject));
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof PersistentObject) {
            PersistentObject loadedObject = (PersistentObject)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public boolean selectBoolean(String statement, Object parameter) {
        List result = this.sqlSession.selectList(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result != null) {
            return result.contains(1);
        }
        return false;
    }

    public <T extends PersistentObject> T selectById(Class<T> entityClass, String id) {
        PersistentObject persistentObject = (PersistentObject)this.cacheGet(entityClass, id);
        if (persistentObject != null) {
            return (T)persistentObject;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        persistentObject = (PersistentObject)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (persistentObject == null) {
            return null;
        }
        this.cachePut(persistentObject, true);
        return (T)persistentObject;
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!PersistentObject.class.isAssignableFrom(loadedObjects.get(0).getClass())) {
            return loadedObjects;
        }
        ArrayList<PersistentObject> filteredObjects = new ArrayList<PersistentObject>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            PersistentObject cachedPersistentObject = this.cacheFilter((PersistentObject)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected CachedObject cachePut(PersistentObject persistentObject, boolean storeState) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObject.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedObject>();
            this.cachedObjects.put(persistentObject.getClass(), classCache);
        }
        CachedObject cachedObject = new CachedObject(persistentObject, storeState);
        classCache.put(persistentObject.getId(), cachedObject);
        return cachedObject;
    }

    protected PersistentObject cacheFilter(PersistentObject persistentObject) {
        PersistentObject cachedPersistentObject = (PersistentObject)this.cacheGet(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.cachePut(persistentObject, true);
        return persistentObject;
    }

    protected <T> T cacheGet(Class<T> entityClass, String id) {
        CachedObject cachedObject = null;
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getPersistentObject();
        }
        return null;
    }

    protected void cacheRemove(Class<?> persistentObjectClass, String persistentObjectId) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObjectClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(persistentObjectId);
    }

    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<PersistentObject> entities = new ArrayList<PersistentObject>(classCache.size());
            for (CachedObject cachedObject : classCache.values()) {
                entities.add(cachedObject.getPersistentObject());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public <T> T findInCache(Class<T> entityClass, String id) {
        return this.cacheGet(entityClass, id);
    }

    public void addDeserializedObject(Object deserializedObject, byte[] serializedBytes, VariableInstanceEntity variableInstanceEntity) {
        this.deserializedObjects.add(new DeserializedObject(deserializedObject, serializedBytes, variableInstanceEntity));
    }

    @Override
    public void flush() {
        this.removeUnnecessaryOperations();
        this.flushDeserializedObjects();
        List<PersistentObject> updatedObjects = this.getUpdatedObjects();
        if (log.isLoggable(Level.FINE)) {
            log.fine("flush summary:");
            for (PersistentObject insertedObject : this.insertedObjects) {
                log.fine("  insert " + this.toString(insertedObject));
            }
            for (PersistentObject updatedObject : updatedObjects) {
                log.fine("  update " + this.toString(updatedObject));
            }
            for (BulkUpdateOperation bulkUpdateOperation : this.bulkUpdates) {
                log.fine(" bulk update " + bulkUpdateOperation);
            }
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                log.fine("  " + deleteOperation);
            }
            log.fine("now executing flush...");
        }
        this.flushInserts();
        this.flushUpdates(updatedObjects);
        this.flushBulkUpdates();
        this.flushDeletes();
    }

    protected void removeUnnecessaryOperations() {
        ArrayList<DeleteOperation> deletedObjectsCopy = new ArrayList<DeleteOperation>(this.deleteOperations);
        for (DeleteOperation deleteOperation : deletedObjectsCopy) {
            if (!(deleteOperation instanceof DeletePersistentObjectOperation)) continue;
            DeletePersistentObjectOperation deletePersistentObjectOperation = (DeletePersistentObjectOperation)deleteOperation;
            PersistentObject insertedObject = this.findInsertedObject(deletePersistentObjectOperation.getPersistentObject().getClass(), deletePersistentObjectOperation.getPersistentObject().getId());
            if (insertedObject != null) {
                this.insertedObjects.remove(insertedObject);
                this.deleteOperations.remove(deleteOperation);
            }
            this.cacheRemove(deletePersistentObjectOperation.getPersistentObject().getClass(), deletePersistentObjectOperation.getPersistentObject().getId());
        }
        for (PersistentObject insertedObject : this.insertedObjects) {
            this.cacheRemove(insertedObject.getClass(), insertedObject.getId());
        }
    }

    protected PersistentObject findInsertedObject(Class<?> persistenceObjectClass, String persistentObjectId) {
        for (PersistentObject insertedObject : this.insertedObjects) {
            if (!insertedObject.getClass().equals(persistenceObjectClass) || !insertedObject.getId().equals(persistentObjectId)) continue;
            return insertedObject;
        }
        return null;
    }

    protected void flushDeserializedObjects() {
        for (DeserializedObject deserializedObject : this.deserializedObjects) {
            deserializedObject.flush();
        }
    }

    public List<PersistentObject> getUpdatedObjects() {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        for (Class<?> clazz : this.cachedObjects.keySet()) {
            Map<String, CachedObject> classCache = this.cachedObjects.get(clazz);
            for (CachedObject cachedObject : classCache.values()) {
                PersistentObject persistentObject = cachedObject.getPersistentObject();
                if (this.isPersistentObjectDeleted(persistentObject)) continue;
                Object originalState = cachedObject.getPersistentObjectState();
                if (!persistentObject.getPersistentState().equals(originalState)) {
                    updatedObjects.add(persistentObject);
                    continue;
                }
                log.finest("loaded object '" + persistentObject + "' was not updated");
            }
        }
        return updatedObjects;
    }

    public boolean isUpdated(PersistentObject persistentObject) {
        return this.getUpdatedObjects().contains(persistentObject);
    }

    protected boolean isPersistentObjectDeleted(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!(deleteOperation instanceof DeletePersistentObjectOperation) || !((DeletePersistentObjectOperation)deleteOperation).getPersistentObject().equals(persistentObject)) continue;
            return true;
        }
        return false;
    }

    public <T extends PersistentObject> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<T> prunedList = new ArrayList<T>(listToPrune);
        for (PersistentObject potentiallyDeleted : listToPrune) {
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                if (!(deleteOperation instanceof DeletePersistentObjectOperation)) continue;
                DeletePersistentObjectOperation deletePersistentObjectOperation = (DeletePersistentObjectOperation)deleteOperation;
                if (!potentiallyDeleted.getClass().equals(deletePersistentObjectOperation.getPersistentObject().getClass()) || !potentiallyDeleted.getId().equals(deletePersistentObjectOperation.getPersistentObject().getId())) continue;
                prunedList.remove(potentiallyDeleted);
            }
        }
        return prunedList;
    }

    protected void flushInserts() {
        for (PersistentObject insertedObject : this.insertedObjects) {
            String insertStatement = this.dbSqlSessionFactory.getInsertStatement(insertedObject);
            if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
                throw new ProcessEngineException("no insert statement for " + insertedObject.getClass() + " in the ibatis mapping files");
            }
            log.fine("inserting: " + this.toString(insertedObject));
            this.sqlSession.insert(insertStatement, (Object)insertedObject);
            if (!(insertedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)insertedObject)).setRevision(((HasRevision)((Object)insertedObject)).getRevisionNext());
        }
        this.insertedObjects.clear();
    }

    protected void flushUpdates(List<PersistentObject> updatedObjects) {
        for (PersistentObject updatedObject : updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ProcessEngineException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("updating: " + this.toString(updatedObject) + "]");
            }
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (!(updatedObject instanceof HasRevision)) continue;
            if (updatedRecords != 1) {
                throw new OptimisticLockingException(this.toString(updatedObject) + " was updated by another transaction concurrently");
            }
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        updatedObjects.clear();
    }

    protected void flushBulkUpdates() {
        for (BulkUpdateOperation bulkUpdateOperation : this.bulkUpdates) {
            String updateStatement = bulkUpdateOperation.getStatement();
            if (updateStatement == null) {
                throw new ProcessEngineException("no update statement " + updateStatement + " in the ibatis mapping files");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("bulk updating: " + bulkUpdateOperation);
            }
            this.sqlSession.update(updateStatement, bulkUpdateOperation.parameter);
        }
    }

    protected void flushDeletes() {
        for (DeleteOperation delete : this.deleteOperations) {
            log.fine("executing: " + delete);
            delete.execute();
        }
        this.deleteOperations.clear();
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    protected String toString(PersistentObject persistentObject) {
        if (persistentObject == null) {
            return "null";
        }
        return ClassNameUtil.getClassNameWithoutPackage(persistentObject) + "[" + persistentObject.getId() + "]";
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw new WrongDbException("fox", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (errorMessage != null) {
                throw new ProcessEngineException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ProcessEngineException("no activiti tables in db.  set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ProcessEngineException("couldn't get db schema version", e);
        }
        log.fine("activiti db schema check successful");
    }

    public void dbCreateHistoryLevel() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(configuredHistoryLevel));
        this.insert(property);
        log.info("Creating historyLevel property in database with value: " + processEngineConfiguration.getHistory());
    }

    public void checkHistoryLevel() {
        Integer configuredHistoryLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        PropertyEntity historyLevelProperty = this.selectById(PropertyEntity.class, "historyLevel");
        if (historyLevelProperty == null) {
            log.info("No historyLevel property found in database.");
            this.dbCreateHistoryLevel();
        } else {
            Integer databaseHistoryLevel = new Integer(historyLevelProperty.getValue());
            if (!configuredHistoryLevel.equals(databaseHistoryLevel)) {
                throw new ProcessEngineException("historyLevel mismatch: configuration says " + configuredHistoryLevel + " and database says " + databaseHistoryLevel);
            }
        }
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (!processEngineConfiguration.isDbHistoryUsed() && configuredHistoryLevel > 0) {
            throw new ProcessEngineException("historyLevel config is higher then 'none' and dbHistoryUsed is set to false");
        }
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw new WrongDbException("fox", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
    }

    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.isIdentityTablePresent() && this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        String dbVersion = null;
        boolean isUpgradeNeeded = false;
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = this.selectById(PropertyEntity.class, "schema.version");
            dbVersion = dbVersionProperty.getValue();
            boolean bl = isUpgradeNeeded = !"fox".equals(dbVersion);
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("fox");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = new PropertyEntity("schema.history", "create(5.0)");
                    this.insert(dbHistoryProperty);
                } else {
                    dbHistoryProperty = this.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "fox" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", dbVersion);
                feedback = "upgraded Activiti from " + dbVersion + " to " + "fox";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", dbVersion);
            }
        } else if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.isIdentityTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("identity", dbVersion);
            }
        } else if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        return feedback;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        tableName = this.prependDatabaseTablePrefix(tableName);
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        try {
            tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                tables.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessEngineException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        tables.close();
        return bl;
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    protected void dbSchemaUpgrade(String component, String dbVersion) {
        log.info("upgrading activiti " + component + " schema from " + dbVersion + " to " + "fox");
        if (dbVersion.endsWith("-SNAPSHOT")) {
            dbVersion = dbVersion.substring(0, dbVersion.length() - "-SNAPSHOT".length());
        }
        int minorDbVersionNumber = Integer.parseInt(dbVersion.substring(2));
        String libraryVersion = "fox";
        if ("fox".endsWith("-SNAPSHOT")) {
            libraryVersion = "fox".substring(0, "fox".length() - "-SNAPSHOT".length());
        }
        int minorLibraryVersionNumber = Integer.parseInt(libraryVersion.substring(2));
        while (minorDbVersionNumber < minorLibraryVersionNumber) {
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep.5" + minorDbVersionNumber + ".to.5" + (minorDbVersionNumber + 1), component), true);
            ++minorDbVersionNumber;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/camunda/bpm/engine/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ProcessEngineException("resource '" + resourceName + "' is not available");
                log.fine("no schema resource " + resourceName + " for " + operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public void executeSchemaResource(String schemaFileResourceName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(schemaFileResourceName));
            this.executeSchemaResource("schema operation", "process engine", schemaFileResourceName, inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ProcessEngineException("Cannot find schema resource file '" + schemaFileResourceName, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing " + operation + " on " + component + " with resource " + resourceName);
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.fine(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.fine(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (ProcessEngineException e) {
                            throw new ProcessEngineException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), e);
                        }
                        try {
                            log.fine("executing upgrade step java class " + upgradestepClassName);
                            dbUpgradeStep.execute(this);
                        }
                        catch (Exception e) {
                            throw new ProcessEngineException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), e);
                        }
                    }
                    if (line.length() > 0) {
                        if (line.endsWith(";")) {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                log.fine("SQL: " + sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                log.log(Level.SEVERE, "problem during schema " + operation + ", statement '" + sqlStatement, e);
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.fine("activiti db schema " + operation + " for component " + component + " successful");
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
        this.checkHistoryLevel();
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new DbUserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new DbGroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public boolean isInsertedObject(PersistentObject persistentObject) {
        return this.insertedObjects.contains(persistentObject);
    }

    public static class CachedObject {
        protected PersistentObject persistentObject;
        protected Object persistentObjectState;

        public CachedObject(PersistentObject persistentObject, boolean storeState) {
            this.persistentObject = persistentObject;
            if (storeState) {
                this.persistentObjectState = persistentObject.getPersistentState();
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public Object getPersistentObjectState() {
            return this.persistentObjectState;
        }
    }

    public class DeletePersistentObjectOperation
    implements DeleteOperation {
        protected PersistentObject persistentObject;

        public DeletePersistentObjectOperation(PersistentObject persistentObject) {
            this.persistentObject = persistentObject;
        }

        @Override
        public void execute() {
            String deleteStatement = DbSqlSession.this.dbSqlSessionFactory.getDeleteStatement(this.persistentObject.getClass());
            if ((deleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ProcessEngineException("no delete statement for " + this.persistentObject.getClass() + " in the ibatis mapping files");
            }
            log.fine("deleting: " + ClassNameUtil.getClassNameWithoutPackage(this.persistentObject.getClass()) + "[" + this.persistentObject.getId() + "]");
            if (this.persistentObject instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
                if (nrOfRowsDeleted == 0) {
                    throw new OptimisticLockingException(DbSqlSession.this.toString(this.persistentObject) + " was updated by another transaction concurrently");
                }
            } else {
                DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public void setPersistentObject(PersistentObject persistentObject) {
            this.persistentObject = persistentObject;
        }

        public String toString() {
            return "Delete operation for " + this.persistentObject.getClass() + " [" + this.persistentObject.getId() + "]";
        }
    }

    public class BulkUpdateOperation {
        String statement;
        Object parameter;

        public BulkUpdateOperation(String statement, Object parameter) {
            this.statement = statement;
            this.parameter = parameter;
        }

        public String getStatement() {
            return this.statement;
        }

        public Object getParameter() {
            return this.parameter;
        }
    }

    public class BulkDeleteOperation
    implements DeleteOperation {
        String statement;
        Object parameter;

        public BulkDeleteOperation(String statement, Object parameter) {
            this.statement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(statement);
            this.parameter = parameter;
        }

        @Override
        public void execute() {
            DbSqlSession.this.sqlSession.delete(this.statement, this.parameter);
        }

        public String toString() {
            return "bulk delete: " + this.statement;
        }
    }

    public static interface DeleteOperation {
        public void execute();
    }
}

