/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.HasDIBounds;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class ActivityImpl
extends ScopeImpl
implements PvmActivity,
HasDIBounds {
    private static final long serialVersionUID = 1L;
    protected List<TransitionImpl> outgoingTransitions = new ArrayList<TransitionImpl>();
    protected Map<String, TransitionImpl> namedOutgoingTransitions = new HashMap<String, TransitionImpl>();
    protected List<TransitionImpl> incomingTransitions = new ArrayList<TransitionImpl>();
    protected ActivityBehavior activityBehavior;
    protected ScopeImpl parent;
    protected boolean isScope;
    protected boolean isAsync;
    protected boolean isExclusive;
    protected boolean isCancelScope = false;
    protected boolean isConcurrent = false;
    protected PvmScope scope;
    protected PvmScope flowScope;
    protected int x = -1;
    protected int y = -1;
    protected int width = -1;
    protected int height = -1;

    public ActivityImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id, processDefinition);
    }

    public TransitionImpl createOutgoingTransition() {
        return this.createOutgoingTransition(null);
    }

    public TransitionImpl createOutgoingTransition(String transitionId) {
        TransitionImpl transition = new TransitionImpl(transitionId, this.processDefinition);
        transition.setSource(this);
        this.outgoingTransitions.add(transition);
        if (transitionId != null) {
            if (this.namedOutgoingTransitions.containsKey(transitionId)) {
                throw new PvmException("activity '" + this.id + " has duplicate transition '" + transitionId + "'");
            }
            this.namedOutgoingTransitions.put(transitionId, transition);
        }
        return transition;
    }

    @Override
    public TransitionImpl findOutgoingTransition(String transitionId) {
        return this.namedOutgoingTransitions.get(transitionId);
    }

    public String toString() {
        return "Activity(" + this.id + ")";
    }

    public ActivityImpl getParentActivity() {
        if (this.parent instanceof ActivityImpl) {
            return (ActivityImpl)this.parent;
        }
        return null;
    }

    protected void setOutgoingTransitions(List<TransitionImpl> outgoingTransitions) {
        this.outgoingTransitions = outgoingTransitions;
    }

    protected void setParent(ScopeImpl parent) {
        this.parent = parent;
    }

    public void setScope(PvmScope scope) {
        this.scope = scope;
    }

    protected void setIncomingTransitions(List<TransitionImpl> incomingTransitions) {
        this.incomingTransitions = incomingTransitions;
    }

    @Override
    public List<PvmTransition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public ActivityBehavior getActivityBehavior() {
        return this.activityBehavior;
    }

    public void setActivityBehavior(ActivityBehavior activityBehavior) {
        this.activityBehavior = activityBehavior;
    }

    @Override
    public ScopeImpl getParent() {
        return this.parent;
    }

    @Override
    public PvmScope getScope() {
        if (this.scope == null) {
            return this.parent;
        }
        return this.scope;
    }

    @Override
    public List<PvmTransition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Deprecated
    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getActivityId() {
        return super.getId();
    }

    @Override
    public ScopeImpl getParentScope() {
        return this.parent;
    }

    @Override
    public boolean isCancelScope() {
        return this.isCancelScope;
    }

    public void setCancelScope(boolean isInterrupting) {
        this.isCancelScope = isInterrupting;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    public PvmScope getFlowScope() {
        if (this.flowScope == null) {
            return this.getScope();
        }
        return this.flowScope;
    }

    public void setFlowScope(PvmScope flowScope) {
        this.flowScope = flowScope;
    }
}

