/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.event;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessApplicationEventListenerTest
extends ResourceProcessEngineTestCase {
    public ProcessApplicationEventListenerTest() {
        super("org/camunda/bpm/application/impl/event/pa.event.listener.camunda.cfg.xml");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void closeDownProcessEngine() {
        this.managementService.unregisterProcessApplication(this.deploymentId, false);
        this.processEngine.close();
        super.closeDownProcessEngine();
    }

    @Deployment(resources={"org/camunda/bpm/application/impl/event/ProcessApplicationEventListenerTest.testExecutionListener.bpmn20.xml"})
    public void testExecutionListenerNull() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
    }

    @Deployment
    public void testExecutionListener() {
        final AtomicInteger eventCount = new AtomicInteger();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public ExecutionListener getExecutionListener() {
                return new ExecutionListener(){

                    public void notify(DelegateExecution execution) throws Exception {
                        eventCount.incrementAndGet();
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        ProcessApplicationEventListenerTest.assertEquals((int)5, (int)eventCount.get());
    }

    @Deployment
    public void testTaskListener() {
        final ArrayList events = new ArrayList();
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication(){

            public TaskListener getTaskListener() {
                return new TaskListener(){

                    public void notify(DelegateTask delegateTask) {
                        events.add(delegateTask.getEventName());
                    }
                };
            }
        };
        this.managementService.registerProcessApplication(this.deploymentId, processApplication.getReference());
        this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        ProcessApplicationEventListenerTest.assertEquals((int)1, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"create", (String)((String)events.get(0)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "jonny");
        ProcessApplicationEventListenerTest.assertEquals((int)2, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"assignment", (String)((String)events.get(1)));
        this.taskService.complete(task.getId());
        ProcessApplicationEventListenerTest.assertEquals((int)3, (int)events.size());
        ProcessApplicationEventListenerTest.assertEquals((String)"complete", (String)((String)events.get(2)));
    }
}

