/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.parser;

import java.net.URL;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.container.impl.metadata.BpmPlatformXmlParser;
import org.camunda.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.camunda.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import org.camunda.bpm.container.impl.metadata.spi.JobExecutorXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEnginePluginXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;

public class BpmPlatformXmlParserTest
extends TestCase {
    private BpmPlatformXmlParser parser;

    protected void setUp() throws Exception {
        this.parser = new BpmPlatformXmlParser();
        super.setUp();
    }

    protected URL getStreamUrl(String filename) {
        return BpmPlatformXmlParserTest.class.getResource(filename);
    }

    public void testParseBpmPlatformXmlNoEngine() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_no_engine.xml")).execute().getBpmPlatformXml();
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml);
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml.getJobExecutor());
        BpmPlatformXmlParserTest.assertEquals((int)0, (int)bpmPlatformXml.getProcessEngines().size());
        JobExecutorXml jobExecutorXml = bpmPlatformXml.getJobExecutor();
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)jobExecutorXml.getJobAcquisitions().size());
        JobAcquisitionXml jobAcquisitionXml = (JobAcquisitionXml)jobExecutorXml.getJobAcquisitions().get(0);
        BpmPlatformXmlParserTest.assertEquals((String)"default", (String)jobAcquisitionXml.getName());
        BpmPlatformXmlParserTest.assertEquals((String)"org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor", (String)jobAcquisitionXml.getJobExecutorClassName());
        BpmPlatformXmlParserTest.assertEquals((int)2, (int)jobAcquisitionXml.getProperties().size());
    }

    public void testParseBpmPlatformXmlOneEngine() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_one_engine.xml")).execute().getBpmPlatformXml();
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml);
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml.getJobExecutor());
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)bpmPlatformXml.getProcessEngines().size());
        JobExecutorXml jobExecutorXml = bpmPlatformXml.getJobExecutor();
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)jobExecutorXml.getJobAcquisitions().size());
        JobAcquisitionXml jobAcquisitionXml = (JobAcquisitionXml)jobExecutorXml.getJobAcquisitions().get(0);
        BpmPlatformXmlParserTest.assertEquals((String)"default", (String)jobAcquisitionXml.getName());
        BpmPlatformXmlParserTest.assertEquals((String)"org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor", (String)jobAcquisitionXml.getJobExecutorClassName());
        BpmPlatformXmlParserTest.assertEquals((int)2, (int)jobAcquisitionXml.getProperties().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        BpmPlatformXmlParserTest.assertEquals((String)"engine1", (String)engineXml.getName());
        BpmPlatformXmlParserTest.assertEquals((String)"default", (String)engineXml.getJobAcquisitionName());
        Map properties = engineXml.getProperties();
        BpmPlatformXmlParserTest.assertNotNull((Object)properties);
        BpmPlatformXmlParserTest.assertEquals((int)0, (int)properties.size());
        List plugins = engineXml.getPlugins();
        BpmPlatformXmlParserTest.assertNotNull((Object)plugins);
        BpmPlatformXmlParserTest.assertEquals((int)0, (int)plugins.size());
    }

    public void testParseBpmPlatformXmlEnginePlugin() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_engine_plugin.xml")).execute().getBpmPlatformXml();
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml);
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)bpmPlatformXml.getProcessEngines().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        BpmPlatformXmlParserTest.assertEquals((String)"engine1", (String)engineXml.getName());
        BpmPlatformXmlParserTest.assertEquals((String)"default", (String)engineXml.getJobAcquisitionName());
        List plugins = engineXml.getPlugins();
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)plugins.size());
        ProcessEnginePluginXml plugin1 = (ProcessEnginePluginXml)plugins.get(0);
        BpmPlatformXmlParserTest.assertNotNull((Object)plugin1);
        BpmPlatformXmlParserTest.assertEquals((String)"org.camunda.bpm.MyAwesomePlugin", (String)plugin1.getPluginClass());
        Map properties = plugin1.getProperties();
        BpmPlatformXmlParserTest.assertNotNull((Object)properties);
        BpmPlatformXmlParserTest.assertEquals((int)2, (int)properties.size());
        String val1 = (String)properties.get("prop1");
        BpmPlatformXmlParserTest.assertNotNull((Object)val1);
        BpmPlatformXmlParserTest.assertEquals((String)"val1", (String)val1);
        String val2 = (String)properties.get("prop2");
        BpmPlatformXmlParserTest.assertNotNull((Object)val2);
        BpmPlatformXmlParserTest.assertEquals((String)"val2", (String)val2);
    }

    public void testParseBpmPlatformXmlMultipleEnginePlugins() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_multiple_engine_plugins.xml")).execute().getBpmPlatformXml();
        BpmPlatformXmlParserTest.assertNotNull((Object)bpmPlatformXml);
        BpmPlatformXmlParserTest.assertEquals((int)1, (int)bpmPlatformXml.getProcessEngines().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        BpmPlatformXmlParserTest.assertEquals((String)"engine1", (String)engineXml.getName());
        BpmPlatformXmlParserTest.assertEquals((String)"default", (String)engineXml.getJobAcquisitionName());
        List plugins = engineXml.getPlugins();
        BpmPlatformXmlParserTest.assertEquals((int)2, (int)plugins.size());
    }
}

