/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.camunda.bpm.engine.impl.form.validator.FormValidators;
import org.camunda.bpm.engine.impl.form.validator.MaxLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MaxValidator;
import org.camunda.bpm.engine.impl.form.validator.MinLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MinValidator;
import org.camunda.bpm.engine.impl.form.validator.ReadOnlyValidator;
import org.camunda.bpm.engine.impl.form.validator.RequiredValidator;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class BuiltInValidatorsTest
extends PluggableProcessEngineTestCase {
    public void testDefaultFormFieldValidators() {
        FormValidators formValidators = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getFormValidators();
        Map validators = formValidators.getValidators();
        BuiltInValidatorsTest.assertEquals(RequiredValidator.class, validators.get("required"));
        BuiltInValidatorsTest.assertEquals(ReadOnlyValidator.class, validators.get("readonly"));
        BuiltInValidatorsTest.assertEquals(MinValidator.class, validators.get("min"));
        BuiltInValidatorsTest.assertEquals(MaxValidator.class, validators.get("max"));
        BuiltInValidatorsTest.assertEquals(MaxLengthValidator.class, validators.get("maxlength"));
        BuiltInValidatorsTest.assertEquals(MinLengthValidator.class, validators.get("minlength"));
    }

    public void testRequiredValidator() {
        RequiredValidator validator = new RequiredValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)1, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)true, null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"", null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate(null, null));
    }

    public void testReadOnlyValidator() {
        ReadOnlyValidator validator = new ReadOnlyValidator();
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"", null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"aaa", null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)11, null));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)2.0, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
    }

    public void testMinValidator() {
        MinValidator validator = new MinValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            e.printStackTrace();
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4.0, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.0f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
    }

    public void testMaxValidator() {
        MaxValidator validator = new MaxValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)3, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("3")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            e.printStackTrace();
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.2")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.2")));
    }

    public void testMaxLengthValidator() {
        MaxLengthValidator validator = new MaxLengthValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("5")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate \"maxlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    public void testMinLengthValidator() {
        MinLengthValidator validator = new MinLengthValidator();
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate(null, null));
        BuiltInValidatorsTest.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        BuiltInValidatorsTest.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            BuiltInValidatorsTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            BuiltInValidatorsTest.assertTrue((boolean)e.getMessage().contains("Cannot validate \"minlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    protected static class TestValidatorContext
    implements FormFieldValidatorContext {
        String configuration;

        public TestValidatorContext(String configuration) {
            this.configuration = configuration;
        }

        public DelegateExecution getExecution() {
            return null;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public Map<String, Object> getSubmittedValues() {
            return null;
        }
    }
}

