/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;
import org.junit.Test;

public class ActivityStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithoutFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theServiceTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidents() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        ActivityStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        ActivityStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        ActivityStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        ActivityStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithInvalidIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidentsForType("invalid").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        ActivityStatisticsQueryTest.assertTrue((boolean)incidentStatistics.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticesTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidentsWithoutFailedJobs() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"callSubProcess", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        List incidentStatistics = activityResult.getIncidentStatistics();
        ActivityStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        ActivityStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        ActivityStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQueryCount() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        long count = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().count();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testManyInstancesActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testParallelMultiInstanceActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("MIExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testSubprocessStatisticsQuery.bpmn20.xml"})
    public void testSubprocessActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((Object)"subProcessTask", (Object)result.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testCallActivityActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)result.getIncidentStatistics().isEmpty());
        ProcessDefinition callSubProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callExampleSubProcess").singleResult();
        List callSubProcessStatistics = this.managementService.createActivityStatisticsQuery(callSubProcessDefinition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)callSubProcessStatistics.size());
        result = (ActivityStatistics)callSubProcessStatistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)result.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testActivityStatisticsQueryWithIntermediateTimer.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIntermediateTimer() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTimer", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        ActivityStatisticsQueryTest.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testNullProcessDefinitionParameter() {
        try {
            this.managementService.createActivityStatisticsQuery(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQueryPagination() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ParGatewayExampleProcess").singleResult();
        this.runtimeService.startProcessInstanceById(definition.getId());
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testParallelGatewayActivityStatisticsQuery() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ParGatewayExampleProcess").singleResult();
        this.runtimeService.startProcessInstanceById(definition.getId());
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ActivityStatistics result : statistics) {
            Assert.assertEquals((long)1L, (long)result.getInstances());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void failing_testActivityStatisticsQueryWithNoInstances() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"theTask", (Object)result.getId());
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
    }
}

