/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;
import org.junit.Test;

public class ProcessDefinitionStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidents() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithInvalidIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("invalid").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsAndFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithoutRunningInstances() {
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryCount() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        long count = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().count();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testMultiInstanceProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testSubprocessStatisticsQuery.bpmn20.xml"})
    public void testSubprocessProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticesTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testCallActivityProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            if (result.getKey().equals("ExampleProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)1L, (long)result.getFailedJobs());
                continue;
            }
            if (result.getKey().equals("callExampleSubProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)0L, (long)result.getFailedJobs());
                continue;
            }
            ProcessDefinitionStatisticsQueryTest.fail((String)(result + " was not expected."));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersions() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithFailedJobsAndIncidents() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId(), parameters);
        }
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        List incidentStatistics = definitionResult.getIncidentStatistics();
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        ProcessDefinitionStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        incidentStatistics = definitionResult.getIncidentStatistics();
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)incidentStatistics.isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.size());
        incident = (IncidentStatistics)incidentStatistics.get(0);
        ProcessDefinitionStatisticsQueryTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incident.getIncidentCount());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithIncidentType() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryPagination() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticesTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsWithoutFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics callExampleSubProcessStaticstics = null;
        ProcessDefinitionStatistics exampleSubProcessStaticstics = null;
        for (ProcessDefinitionStatistics current : statistics) {
            if (current.getKey().equals("callExampleSubProcess")) {
                callExampleSubProcessStaticstics = current;
                continue;
            }
            if (current.getKey().equals("ExampleProcess")) {
                exampleSubProcessStaticstics = current;
                continue;
            }
            ProcessDefinitionStatisticsQueryTest.fail((String)(current.getKey() + " was not expected."));
        }
        ProcessDefinitionStatisticsQueryTest.assertNotNull(callExampleSubProcessStaticstics);
        ProcessDefinitionStatisticsQueryTest.assertNotNull(exampleSubProcessStaticstics);
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)callExampleSubProcessStaticstics.getInstances());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)0, (int)callExampleSubProcessStaticstics.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)callExampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)callExampleSubProcessStaticstics.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)callExampleSubProcessStaticstics.getIncidentStatistics().get(0);
        ProcessDefinitionStatisticsQueryTest.assertEquals((String)"failedJob", (String)incidentStatistics.getIncidentType());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.getIncidentCount());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)exampleSubProcessStaticstics.getInstances());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)exampleSubProcessStaticstics.getFailedJobs());
        ProcessDefinitionStatisticsQueryTest.assertFalse((boolean)exampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)exampleSubProcessStaticstics.getIncidentStatistics().size());
        incidentStatistics = (IncidentStatistics)exampleSubProcessStaticstics.getIncidentStatistics().get(0);
        ProcessDefinitionStatisticsQueryTest.assertEquals((String)"failedJob", (String)incidentStatistics.getIncidentType());
        ProcessDefinitionStatisticsQueryTest.assertEquals((int)1, (int)incidentStatistics.getIncidentCount());
    }
}

