/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class ProcessApplicationDeploymentTest
extends PluggableProcessEngineTestCase {
    private EmbeddedProcessApplication processApplication;

    protected void setUp() throws Exception {
        this.processApplication = new EmbeddedProcessApplication();
    }

    public void testSimpleProcessApplicationDeployment() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinition);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testProcessApplicationDeploymentNoChanges() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinition);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
        deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinition);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testProcessApplicationDeploymentResumePreviousVersions() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinition);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering().resumePreviousVersions().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.repositoryService.deleteDeployment(deployment1.getId(), true);
        this.repositoryService.deleteDeployment(deployment2.getId(), true);
    }

    public void testProcessApplicationDeploymentNoResume() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinition);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.repositoryService.deleteDeployment(deployment1.getId(), true);
        this.repositoryService.deleteDeployment(deployment2.getId(), true);
    }
}

