/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class ProcessDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    private String deploymentOneId;
    private String deploymentTwoId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/two.bpmn20.xml").deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").deploy().getId();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    public void testProcessDefinitionProperties() {
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).orderByProcessDefinitionCategory().asc()).list();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"One", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("one:1"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples", (String)processDefinition.getCategory());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"One", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("one:2"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples", (String)processDefinition.getCategory());
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        ProcessDefinitionQueryTest.assertEquals((String)"two", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"Two", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("two:1"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples2", (String)processDefinition.getCategory());
    }

    public void testQueryByDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId(this.deploymentOneId);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().deploymentId(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("Two");
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("One");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionName(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%w%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one");
        this.verifyQueryResults(query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%o%");
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCategory() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategory("Examples");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByCategoryLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%Example%");
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%amples2");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(-1)).list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(null).list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKeyAndVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByLatest() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().latestVersion();
        this.verifyQueryResults(query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").latestVersion();
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two").latestVersion();
        this.verifyQueryResults(query, 1);
    }

    public void testInvalidUsageOfLatest() {
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionId("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionName("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().deploymentId("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc();
        List processDefinitions = query.list();
        ProcessDefinitionQueryTest.assertEquals((int)3, (int)processDefinitions.size());
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)((ProcessDefinition)processDefinitions.get(1)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessDefinitionQueryTest.assertEquals((String)"two", (String)((ProcessDefinition)processDefinitions.get(2)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(2)).getVersion());
    }

    private void verifyQueryResults(ProcessDefinitionQuery query, int countExpected) {
        ProcessDefinitionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        ProcessDefinitionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            ProcessDefinitionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            ProcessDefinitionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(ProcessDefinitionQuery query) {
        try {
            query.singleResult();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByMessageSubscription() {
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processWithNewBookingMessage.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/repository/processWithNewInvoiceMessage.bpmn20.xml").deploy();
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newInvoiceMessage").count());
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newBookingMessage").count());
        ProcessDefinitionQueryTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("bogus").count());
        this.repositoryService.deleteDeployment(deployment.getId());
    }
}

