/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class IncidentQueryTest
extends PluggableProcessEngineTestCase {
    private static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";
    private List<String> processInstanceIds;

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml").deploy();
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.waitForJobExecutorToProcessAllJobs(15000L);
    }

    protected void tearDown() throws Exception {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        super.tearDown();
    }

    public void testQuery() {
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByIncidentType() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentType("failedJob");
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByInvalidIncidentType() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentType("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByIncidentMessage() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentMessage("Expected exception.");
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByInvalidIncidentMessage() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentMessage("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        IncidentQuery query = this.runtimeService.createIncidentQuery().processDefinitionId(processDefinitionId);
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByInvalidProcessDefinitionId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processDefinitionId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByProcessInstanceId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId(this.processInstanceIds.get(0));
        IncidentQueryTest.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)1, (int)incidents.size());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNotNull((Object)incident);
    }

    public void testQueryByInvalidProcessInstanceId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByIncidentId() {
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        IncidentQueryTest.assertNotNull((Object)incident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentId(incident.getId());
        IncidentQueryTest.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)1, (int)incidents.size());
    }

    public void testQueryByInvalidIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().incidentId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByExecutionId() {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        IncidentQueryTest.assertNotNull((Object)execution);
        IncidentQuery query = this.runtimeService.createIncidentQuery().executionId(execution.getId());
        IncidentQueryTest.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)1, (int)incidents.size());
    }

    public void testQueryByInvalidExecutionId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().executionId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByActivityId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().activityId("theServiceTask");
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByInvalidActivityId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().activityId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByConfiguration() {
        String jobId = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult()).getId();
        IncidentQuery query = this.runtimeService.createIncidentQuery().configuration(jobId);
        IncidentQueryTest.assertEquals((long)1L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)1, (int)incidents.size());
    }

    public void testQueryByInvalidConfiguration() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().configuration("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        Incident incident = (Incident)query.singleResult();
        IncidentQueryTest.assertNull((Object)incident);
    }

    public void testQueryByCauseIncidentIdEqualsNull() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId(null);
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByInvalidCauseIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)0, (int)incidents.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByCauseIncidentId.bpmn"})
    public void testQueryByCauseIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingProcess");
        this.waitForJobExecutorToProcessAllJobs(15000L);
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        IncidentQueryTest.assertNotNull((Object)subProcessInstance);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(subProcessInstance.getId()).singleResult();
        IncidentQueryTest.assertNotNull((Object)causeIncident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().causeIncidentId(causeIncident.getId());
        IncidentQueryTest.assertEquals((long)2L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)2, (int)incidents.size());
    }

    public void testQueryByRootCauseIncidentIdEqualsNull() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId(null);
        IncidentQueryTest.assertEquals((long)4L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)4, (int)incidents.size());
    }

    public void testQueryByRootInvalidCauseIncidentId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId("invalid");
        IncidentQueryTest.assertEquals((long)0L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertTrue((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)0, (int)incidents.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByRootCauseIncidentId.bpmn", "org/camunda/bpm/engine/test/api/runtime/IncidentQueryTest.testQueryByCauseIncidentId.bpmn"})
    public void testQueryByRootCauseIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingCallActivity");
        this.waitForJobExecutorToProcessAllJobs(15000L);
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        IncidentQueryTest.assertNotNull((Object)subProcessInstance);
        ProcessInstance failingSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        IncidentQueryTest.assertNotNull((Object)subProcessInstance);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(failingSubProcessInstance.getId()).singleResult();
        IncidentQueryTest.assertNotNull((Object)incident);
        IncidentQuery query = this.runtimeService.createIncidentQuery().rootCauseIncidentId(incident.getId());
        IncidentQueryTest.assertEquals((long)3L, (long)query.count());
        List incidents = query.list();
        IncidentQueryTest.assertFalse((boolean)incidents.isEmpty());
        IncidentQueryTest.assertEquals((int)3, (int)incidents.size());
        try {
            query.singleResult();
            IncidentQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    public void testQueryPaging() {
        IncidentQueryTest.assertEquals((int)4, (int)this.runtimeService.createIncidentQuery().listPage(0, 4).size());
        IncidentQueryTest.assertEquals((int)1, (int)this.runtimeService.createIncidentQuery().listPage(2, 1).size());
        IncidentQueryTest.assertEquals((int)2, (int)this.runtimeService.createIncidentQuery().listPage(1, 2).size());
        IncidentQueryTest.assertEquals((int)3, (int)this.runtimeService.createIncidentQuery().listPage(1, 4).size());
    }

    public void testQuerySorting() {
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentTimestamp().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentType().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByExecutionId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByActivityId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessInstanceId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessDefinitionId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByCauseIncidentId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByRootCauseIncidentId().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByConfiguration().asc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentTimestamp().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByIncidentType().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByExecutionId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByActivityId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessInstanceId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByProcessDefinitionId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByCauseIncidentId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByRootCauseIncidentId().desc()).list().size());
        IncidentQueryTest.assertEquals((int)4, (int)((IncidentQuery)this.runtimeService.createIncidentQuery().orderByConfiguration().desc()).list().size());
    }
}

