/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.HashMap;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageCorrelationTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchingMessageEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "anotherValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("aNewKey", "aNewVariable");
        this.runtimeService.correlateMessage(messageName, correlationKeys, messagePayload);
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testTwoMatchingProcessInstancesCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        try {
            this.runtimeService.correlateMessage(messageName, correlationKeys);
            MessageCorrelationTest.fail((String)"Expected an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("2 executions match the correlation keys.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKey() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKeyWithVariables() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey, variables);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
    }

    public void testNullMessageEventCorrelation() {
        try {
            this.runtimeService.correlateMessage(null);
            MessageCorrelationTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("messageName cannot be null", e.getMessage());
        }
    }

    @Deployment
    public void testMessageStartEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    public void testMessageStartEventCorrelationBusKey() {
        String businessKey = "aBusinessKey";
        this.runtimeService.correlateMessage("newInvoiceMessage", "aBusinessKey");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)processInstance.getBusinessKey());
    }

    @Deployment
    public void testMultipleMessageStartEventsCorrelation() {
        this.runtimeService.correlateMessage("someMessage");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.correlateMessage("someOtherMessage");
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment
    public void testMatchingStartEventAndExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageCorrelationTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.correlateMessage("newInvoiceMessage");
        MessageCorrelationTest.assertNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
    }

    public void testMessageStartEventCorrelationWithNonMatchingDefinition() {
        try {
            this.runtimeService.correlateMessage("aMessageName");
            MessageCorrelationTest.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("Cannot correlate message", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "anotherBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("aProcessVariable", "aVariableValue");
        this.runtimeService.correlateMessage(messageName, "aBusinessKey", correlationKeys, processVariables);
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").singleResult();
        MessageCorrelationTest.assertNotNull((Object)correlatedExecution);
        ProcessInstance correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)correlatedProcessInstance.getBusinessKey());
    }
}

