/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessInstanceSuspensionTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testProcessInstanceActiveByDefault() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuspendActivateProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuspendActivateProcessInstanceByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuspendActivateProcessInstanceByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testActivateAlreadyActiveProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        try {
            this.runtimeService.activateProcessInstanceById(processInstance.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuspendAlreadySuspendedProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceSuspensionTest.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.suspendProcessInstanceById(processInstance.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            ProcessInstanceSuspensionTest.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"Should not fail");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryForActiveAndSuspendedProcessInstances() {
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceById(piToSuspend.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((String)piToSuspend.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryForActiveAndSuspendedProcessInstancesByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((String)piToSuspend.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryForActiveAndSuspendedProcessInstancesByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((String)piToSuspend.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskSuspendedAfterProcessInstanceSuspension() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskSuspendedAfterProcessInstanceSuspensionByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskSuspendedAfterProcessInstanceSuspensionByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskQueryAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskQueryAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskQueryAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspend() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testChildExecutionsSuspendedAfterProcessInstanceSuspend.bpmn20.xml"})
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testChildExecutionsSuspendedAfterProcessInstanceSuspend.bpmn20.xml"})
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("testChildExecutionsSuspended");
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("testChildExecutionsSuspended");
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceSuspensionTest.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testChangeVariablesAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testChangeVariablesAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testChangeVariablesAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            ProcessInstanceSuspensionTest.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskFormFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskFormFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskFormFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessInstanceSignalFailAfterSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.signal(processInstance.getId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessInstanceSignalFailAfterSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.runtimeService.signal(processInstance.getId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessInstanceSignalFailAfterSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.runtimeService.signal(processInstance.getId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment
    public void testMessageEventReceiveFailAfterSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testMessageEventReceiveFailAfterSuspend.bpmn20.xml"})
    public void testMessageEventReceiveFailAfterSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testMessageEventReceiveFailAfterSuspend.bpmn20.xml"})
    public void testMessageEventReceiveFailAfterSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment
    public void testSignalEventReceivedAfterProcessInstanceSuspended() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testSignalEventReceivedAfterProcessInstanceSuspended.bpmn20.xml"})
    public void testSignalEventReceivedAfterProcessInstanceSuspendedByProcessDefinitionId() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testSignalEventReceivedAfterProcessInstanceSuspended.bpmn20.xml"})
    public void testSignalEventReceivedAfterProcessInstanceSuspendedByProcessDefinitionKey() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("signalSuspendedProcessInstance").singleResult();
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            ProcessInstanceSuspensionTest.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            ProcessInstanceSuspensionTest.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubTaskCreationFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            ProcessInstanceSuspensionTest.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubTaskCreationFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            ProcessInstanceSuspensionTest.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubTaskCreationFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            ProcessInstanceSuspensionTest.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspend() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            try {
                this.taskService.addComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspendByProcessDefinitionId() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            try {
                this.taskService.addComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            try {
                this.taskService.addComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                ProcessInstanceSuspensionTest.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            ProcessInstanceSuspensionTest.fail((String)"should be allowed");
        }
    }

    @Deployment
    public void testJobNotExecutedAfterProcessInstanceSuspend() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testJobNotExecutedAfterProcessInstanceSuspend.bpmn20.xml"})
    public void testJobNotExecutedAfterProcessInstanceSuspendByProcessDefinitionId() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testJobNotExecutedAfterProcessInstanceSuspend.bpmn20.xml"})
    public void testJobNotExecutedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testCallActivityReturnAfterProcessInstanceSuspend() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceById(instance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(instance.getId());
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testCallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testCallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callSimpleProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.taskService.complete(task.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testMICallActivityReturnAfterProcessInstanceSuspend() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceById(instance.getId());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        this.taskService.complete(task1.getId());
        try {
            this.taskService.complete(task2.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(instance.getId());
        this.taskService.complete(task2.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testMICallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        this.taskService.complete(task1.getId());
        try {
            this.taskService.complete(task2.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        this.taskService.complete(task2.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testMICallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callMISimpleProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        this.taskService.complete(task1.getId());
        try {
            this.taskService.complete(task2.getId());
            ProcessInstanceSuspensionTest.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException e) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.taskService.complete(task2.getId());
        ProcessInstanceSuspensionTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }
}

