/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class AsyncStartEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testAsyncStartEvent() {
        this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        Assert.assertNotNull((String)"The user task should have been reached", (Object)task);
    }

    @Deployment
    public void testAsyncStartEventListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
        this.waitForJobExecutorToProcessAllJobs(6000L);
        Assert.assertNotNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventHistory() {
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
            Assert.assertNotNull((Object)historicInstance);
            Assert.assertNotNull((Object)historicInstance.getStartTime());
            HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
            Assert.assertNull((Object)historicStartEvent);
        }
    }
}

