/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.end;

import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TerminateEndEventTest
extends PluggableProcessEngineTestCase {
    public static int serviceTaskInvokedCount = 0;
    public static int serviceTaskInvokedCount2 = 0;

    @Deployment
    public void testProcessTerminate() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).count();
        TerminateEndEventTest.assertEquals((long)3L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preTerminateTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateWithSubProcess() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).count();
        TerminateEndEventTest.assertEquals((long)4L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preTerminateEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.testTerminateWithCallActivity.bpmn", "org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.subProcessNoTerminate.bpmn"})
    public void testTerminateWithCallActivity() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).count();
        TerminateEndEventTest.assertEquals((long)4L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preTerminateEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateInSubProcess() throws Exception {
        serviceTaskInvokedCount = 0;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateInSubProcessConcurrent() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateInSubProcessConcurrentMultiInstance() throws Exception {
        serviceTaskInvokedCount = 0;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)12L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        long executionEntities2 = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)10L, (long)executionEntities2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task t : tasks) {
            this.taskService.complete(t.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateInSubProcessMultiInstance() throws Exception {
        serviceTaskInvokedCount = 0;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTerminateInSubProcessSequentialConcurrentMultiInstance() throws Exception {
        serviceTaskInvokedCount = 0;
        serviceTaskInvokedCount2 = 0;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long remainingExecutions = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)remainingExecutions);
        TerminateEndEventTest.assertEquals((int)3, (int)serviceTaskInvokedCount2);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.testTerminateInCallActivity.bpmn", "org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.subProcessTerminate.bpmn"})
    public void testTerminateInCallActivity() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.testTerminateInCallActivityMulitInstance.bpmn", "org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.subProcessTerminate.bpmn"})
    public void testTerminateInCallActivityMulitInstance() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.testTerminateInCallActivityConcurrent.bpmn", "org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.subProcessConcurrentTerminate.bpmn"})
    public void testTerminateInCallActivityConcurrent() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.testTerminateInCallActivityConcurrentMulitInstance.bpmn", "org/camunda/bpm/engine/test/bpmn/event/end/TerminateEndEventTest.subProcessConcurrentTerminate.bpmn"})
    public void testTerminateInCallActivityConcurrentMulitInstance() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("terminateEndEventExample");
        long executionEntities = this.runtimeService.createExecutionQuery().count();
        TerminateEndEventTest.assertEquals((long)1L, (long)executionEntities);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).taskDefinitionKey("preNormalEnd").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    public static class CountDelegate2
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            ++serviceTaskInvokedCount2;
        }
    }

    public static class CountDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariableLocal("terminate", (Object)(++serviceTaskInvokedCount > 3 ? 1 : 0));
        }
    }
}

