/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageEventSubprocessTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(1);
    }

    @Deployment
    public void testTwoInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(2);
    }

    private void testInterruptingUnderProcessDefinition(int expectedNumberOfEventSubscriptions) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)expectedNumberOfEventSubscriptions, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcessTask", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinitionScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }
}

