/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageStartEventTest
extends PluggableProcessEngineTestCase {
    public void testDeploymentCreatesSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)eventSubscriptions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testSameMessageNameFails() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/otherProcessWithNewInvoiceMessage.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("there already is a message event subscription for the message with name"));
        }
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
        }
    }

    public void testSameMessageNameInSameProcessFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/testSameMessageNameInSameProcessFails.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have more than one message event subscription with name 'newInvoiceMessage' for scope"));
        }
    }

    public void testUpdateProcessVersionCancelsSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)eventSubscriptions.size());
        MessageStartEventTest.assertEquals((int)1, (int)processDefinitions.size());
        String newDeploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List newProcessDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)newEventSubscriptions.size());
        MessageStartEventTest.assertEquals((int)2, (int)newProcessDefinitions.size());
        for (ProcessDefinition processDefinition : newProcessDefinitions) {
            EventSubscriptionEntity subscriptionEntity;
            if (processDefinition.getVersion() == 1) {
                for (EventSubscription subscription : newEventSubscriptions) {
                    subscriptionEntity = (EventSubscriptionEntity)subscription;
                    MessageStartEventTest.assertFalse((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
                }
                continue;
            }
            for (EventSubscription subscription : newEventSubscriptions) {
                subscriptionEntity = (EventSubscriptionEntity)subscription;
                MessageStartEventTest.assertTrue((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
            }
        }
        MessageStartEventTest.assertFalse((boolean)((Object)eventSubscriptions).equals(newEventSubscriptions));
        this.repositoryService.deleteDeployment(deploymentId);
        this.repositoryService.deleteDeployment(newDeploymentId);
    }

    @Deployment
    public void testSingleMessageStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("singleMessageStartEvent");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMessageStartEventAndNoneStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterNoneStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMultipleMessageStartEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage2");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart2").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((String)("different exception expected, not " + e.getMessage()), (boolean)e.getMessage().contains("has no default start activity"));
        }
    }
}

