/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;

public class StartTimerEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testDurationStartTimerEvent() throws Exception {
        Date startTime = new Date();
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3005000L));
        this.executeAllJobs();
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testFixedDateStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void FAILING_testCycleDateStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample");
        StartTimerEventTest.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.cleanDB();
    }

    private void moveByMinutes(int minutes) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(minutes * 60 * 1000 + 5000)));
    }

    @Deployment
    public void testCycleWithLimitStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExampleCycle");
        StartTimerEventTest.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)2L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testExpressionStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testVersionUpgradeShouldCancelJobs() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)"")).replaceAll("beforeChange", "changed");
        IoUtil.closeSilently((InputStream)in);
        in = new ByteArrayInputStream(process.getBytes());
        String id = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((InputStream)in);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").singleResult();
        String pi = processInstance.getProcessInstanceId();
        StartTimerEventTest.assertEquals((String)"changed", (String)((String)this.runtimeService.getActiveActivityIds(pi).get(0)));
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.cleanDB();
        this.repositoryService.deleteDeployment(id, true);
    }

    @Deployment
    public void testTimerShouldNotBeRecreatedOnDeploymentCacheReboot() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("startTimer");
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
    }

    public void testTimerShouldNotBeRemovedWhenUndeployingOldVersion() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("StartTimerEventTest.testTimerShouldNotBeRemovedWhenUndeployingOldVersion.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)""));
        IoUtil.closeSilently((InputStream)in);
        in = new ByteArrayInputStream(process.getBytes());
        String firstDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((InputStream)in);
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String processChanged = process.replaceAll("beforeChange", "changed");
        in = new ByteArrayInputStream(processChanged.getBytes());
        String secondDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((InputStream)in);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.cleanDB();
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    protected void executeAllJobs() {
        String nextJobId = this.getNextExecutableJobId();
        while (nextJobId != null) {
            try {
                this.managementService.executeJob(nextJobId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nextJobId = this.getNextExecutableJobId();
        }
    }

    protected String getNextExecutableJobId() {
        List jobs = this.managementService.createJobQuery().executable().listPage(0, 1);
        if (jobs.size() == 1) {
            return ((Job)jobs.get(0)).getId();
        }
        return null;
    }

    private void cleanDB() {
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new DeleteJobsCmd(jobId));
    }
}

