/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.receivetask;

import java.util.List;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ReceiveTaskTest
extends PluggableProcessEngineTestCase {
    private List<EventSubscription> getEventSubscriptionList() {
        return this.runtimeService.createEventSubscriptionQuery().eventType("message").list();
    }

    private List<EventSubscription> getEventSubscriptionList(String activityId) {
        return this.runtimeService.createEventSubscriptionQuery().eventType("message").activityId(activityId).list();
    }

    private String getExecutionId(String processInstanceId, String activityId) {
        return ((Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activityId).singleResult()).getId();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.simpleReceiveTask.bpmn20.xml"})
    public void testReceiveTaskWithoutMessageReference() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    public void testSupportsLegacySignalingOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ReceiveTaskTest.assertEquals((int)1, (int)this.getEventSubscriptionList().size());
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    public void testSupportsCorrelateMessageOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.correlateMessage(subscription.getEventName());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    public void testSupportsLegacySignalingOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        subscription = subscriptionList.get(0);
        ReceiveTaskTest.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        subscription = subscriptionList.get(0);
        ReceiveTaskTest.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    public void testSupportsCorrelateMessageOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.correlateMessage(subscription.getEventName());
        subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        subscription = subscriptionList.get(0);
        ReceiveTaskTest.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.correlateMessage(subscription.getEventName());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    public void testSupportsLegacySignalingOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("waitState").messageEventSubscriptionName("newInvoiceMessage").list();
        ReceiveTaskTest.assertEquals((int)2, (int)executions.size());
        this.runtimeService.signal(((Execution)executions.get(0)).getId());
        this.runtimeService.signal(((Execution)executions.get(1)).getId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    public void testNotSupportsCorrelateMessageOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        try {
            this.runtimeService.correlateMessage(subscriptions.get(0).getEventName());
            ReceiveTaskTest.fail((String)"should throw a mismatch");
        }
        catch (MismatchingMessageCorrelationException mismatchingMessageCorrelationException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskCompensate.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnParallelMultiReceiveTaskWithCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        ReceiveTaskTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        ReceiveTaskTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskBoundary.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnParallelMultiInstanceWithBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ReceiveTaskTest.assertEquals((int)3, (int)this.getEventSubscriptionList().size());
        List<EventSubscription> subscriptions = this.getEventSubscriptionList("waitState");
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskBoundary.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnParallelMultiInstanceWithBoundaryEventReceived() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ReceiveTaskTest.assertEquals((int)3, (int)this.getEventSubscriptionList().size());
        List<EventSubscription> subscriptions = this.getEventSubscriptionList("cancel");
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptions.size());
        EventSubscription subscription = subscriptions.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.subProcessReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnSubProcessReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)1, (int)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSubProcessReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnMultiSubProcessReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.parallelGatewayReceiveTask.bpmn20.xml"})
    public void testSupportsMessageEventReceivedOnReceiveTaskBehindParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.parallelGatewayReceiveTask.bpmn20.xml"})
    public void testSupportsCorrelateMessageOnReceiveTaskBehindParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        ReceiveTaskTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.correlateMessage(subscriptions.get(0).getEventName());
        this.runtimeService.correlateMessage(subscriptions.get(1).getEventName());
        ReceiveTaskTest.assertEquals((int)0, (int)this.getEventSubscriptionList().size());
        this.assertProcessEnded(processInstance.getId());
    }
}

