/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.subprocess;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class InterruptingEventSubProcessTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/InterruptingEventSubProcessTest.testCancelEventSubscriptions.bpmn"})
    public void testCancelEventSubscriptionsWhenReceivingAMessage() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskBeforeInterruptingEventSuprocess", (String)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        InterruptingEventSubProcessTest.assertEquals((int)2, (int)eventSubscriptions.size());
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        InterruptingEventSubProcessTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        try {
            this.runtimeService.signalEventReceived("newSignal", pi.getId());
            InterruptingEventSubProcessTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/InterruptingEventSubProcessTest.testCancelEventSubscriptions.bpmn"})
    public void testCancelEventSubscriptionsWhenReceivingASignal() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskBeforeInterruptingEventSuprocess", (String)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        InterruptingEventSubProcessTest.assertEquals((int)2, (int)eventSubscriptions.size());
        this.runtimeService.signalEventReceived("newSignal", pi.getId());
        task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"tastAfterSignalStartEvent", (String)task.getTaskDefinitionKey());
        InterruptingEventSubProcessTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        try {
            this.runtimeService.messageEventReceived("newMessage", pi.getId());
            InterruptingEventSubProcessTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testCancelTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        JobQuery jobQuery = this.managementService.createJobQuery().timers();
        Task task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskBeforeInterruptingEventSuprocess", (String)task.getTaskDefinitionKey());
        Job timer = (Job)jobQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)timer);
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        InterruptingEventSubProcessTest.assertEquals((long)0L, (long)jobQuery.count());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testKeepCompensation() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskBeforeInterruptingEventSuprocess", (String)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        InterruptingEventSubProcessTest.assertEquals((int)2, (int)eventSubscriptions.size());
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        InterruptingEventSubProcessTest.assertNotNull((Object)task);
        InterruptingEventSubProcessTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        InterruptingEventSubProcessTest.assertEquals((long)1L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }
}

