/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.subprocess;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class SubProcessTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"subProcess", (String)subProcessInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)subProcessInstance.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"subProcessTask", (String)userTaskInstance.getActivityId());
        this.taskService.complete(subProcessTask.getId());
        SubProcessTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult());
    }

    @Deployment
    public void testSimpleAutomaticSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcessAutomatic");
        SubProcessTest.assertTrue((boolean)pi.isEnded());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSimpleSubProcessWithTimer() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"subProcess", (String)subProcessInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)subProcessInstance.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"subProcessTask", (String)userTaskInstance.getActivityId());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 0x6DDD00L + 1000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        Task escalationTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Fix escalated problem", (String)escalationTask.getName());
    }

    @Deployment
    public void IGNORE_testSimpleSubProcessWithConcurrentTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcessWithConcurrentTimer");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        Task subProcessTask = (Task)taskQuery.singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        List tasksAfterTimer = taskQuery.list();
        SubProcessTest.assertEquals((int)2, (int)tasksAfterTimer.size());
        Task taskAfterTimer1 = (Task)tasksAfterTimer.get(0);
        Task taskAfterTimer2 = (Task)tasksAfterTimer.get(1);
        SubProcessTest.assertEquals((String)"Task after timer 1", (String)taskAfterTimer1.getName());
        SubProcessTest.assertEquals((String)"Task after timer 2", (String)taskAfterTimer2.getName());
        this.taskService.complete(taskAfterTimer1.getId());
        this.taskService.complete(taskAfterTimer2.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNestedSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess", CollectionUtil.singletonMap((String)"someVar", (Object)"abc"));
        this.runtimeService.deleteProcessInstance(pi.getId(), "deleted");
        pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"outerSubProcess", (String)subProcessInstance1.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance2 = subProcessInstance1.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"innerSubProcess", (String)subProcessInstance2.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)subProcessInstance2.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance2.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"innerSubProcessTask", (String)userTaskInstance.getActivityId());
        this.taskService.complete(subProcessTask.getId());
        Task taskAfterSubProcesses = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertNotNull((Object)taskAfterSubProcesses);
        SubProcessTest.assertEquals((String)"Task after subprocesses", (String)taskAfterSubProcesses.getName());
        this.taskService.complete(taskAfterSubProcesses.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNestedSimpleSubprocessWithTimerOnInnerSubProcess() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSubProcessWithTimer");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"outerSubProcess", (String)subProcessInstance1.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance2 = subProcessInstance1.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"innerSubProcess", (String)subProcessInstance2.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)subProcessInstance2.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance2.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"innerSubProcessTask", (String)userTaskInstance.getActivityId());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3600000L + 1000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        Task escalationTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Escalated task", (String)escalationTask.getName());
        rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"outerSubProcess", (String)subProcessInstance1.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance escalationTaskInst = subProcessInstance1.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"escalationTask", (String)escalationTaskInst.getActivityId());
        this.taskService.complete(escalationTask.getId());
        Task taskAfterSubProcess = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task after subprocesses", (String)taskAfterSubProcess.getName());
    }

    @Deployment
    public void testDoubleNestedSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        this.taskService.complete(subProcessTask.getId());
        Task taskAfterSubProcesses = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task after subprocesses", (String)taskAfterSubProcesses.getName());
    }

    @Deployment
    public void testSimpleParallelSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleParallelSubProcess");
        List subProcessTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        Task taskA = (Task)subProcessTasks.get(0);
        Task taskB = (Task)subProcessTasks.get(1);
        SubProcessTest.assertEquals((String)"Task A", (String)taskA.getName());
        SubProcessTest.assertEquals((String)"Task B", (String)taskB.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"subProcess", (String)subProcessInstance.getActivityId());
        SubProcessTest.assertEquals((int)2, (int)subProcessInstance.getChildActivityInstances().length);
        this.taskService.complete(taskA.getId());
        rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((int)2, (int)subProcessInstance.getChildActivityInstances().length);
        this.taskService.complete(taskB.getId());
        Task taskAfterSubProcess = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task after sub process", (String)taskAfterSubProcess.getName());
    }

    @Deployment
    public void testSimpleParallelSubProcessWithTimer() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("simpleParallelSubProcessWithTimer");
        List subProcessTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).orderByTaskName().asc()).list();
        Task taskA = (Task)subProcessTasks.get(0);
        Task taskB = (Task)subProcessTasks.get(1);
        SubProcessTest.assertEquals((String)"Task A", (String)taskA.getName());
        SubProcessTest.assertEquals((String)"Task B", (String)taskB.getName());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Task after timer", (String)taskAfterTimer.getName());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testTwoSubProcessInParallel() {
        ActivityInstance[] childActivityInstances;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallel");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        SubProcessTest.assertEquals((String)"Task in subprocess A", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"Task in subprocess B", (String)((Task)tasks.get(1)).getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)2, (int)rootActivityInstance.getChildActivityInstances().length);
        for (ActivityInstance activityInstance : childActivityInstances = rootActivityInstance.getChildActivityInstances()) {
            SubProcessTest.assertTrue((boolean)Arrays.asList("subProcessA", "subProcessB").contains(activityInstance.getActivityId()));
            ActivityInstance[] subProcessChildren = activityInstance.getChildActivityInstances();
            SubProcessTest.assertEquals((int)1, (int)subProcessChildren.length);
            SubProcessTest.assertTrue((boolean)Arrays.asList("subProcessATask", "subProcessBTask").contains(subProcessChildren[0].getActivityId()));
        }
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = taskQuery.list();
        SubProcessTest.assertEquals((String)"Task after subprocess A", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"Task in subprocess B", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = taskQuery.list();
        SubProcessTest.assertEquals((String)"Task after subprocess A", (String)((Task)tasks.get(0)).getName());
        SubProcessTest.assertEquals((String)"Task after subprocess B", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ActivityInstance[] childActivityInstances;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        SubProcessTest.assertEquals((String)"Task in subprocess A", (String)taskA.getName());
        SubProcessTest.assertEquals((String)"Task in subprocess B", (String)taskB.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        SubProcessTest.assertEquals((String)pi.getProcessDefinitionId(), (String)rootActivityInstance.getActivityId());
        SubProcessTest.assertEquals((int)1, (int)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance outerSubProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        SubProcessTest.assertEquals((String)"outerSubProcess", (String)outerSubProcessInstance.getActivityId());
        for (ActivityInstance activityInstance : childActivityInstances = outerSubProcessInstance.getChildActivityInstances()) {
            SubProcessTest.assertTrue((boolean)Arrays.asList("subProcessA", "subProcessB").contains(activityInstance.getActivityId()));
            ActivityInstance[] subProcessChildren = activityInstance.getChildActivityInstances();
            SubProcessTest.assertEquals((int)1, (int)subProcessChildren.length);
            SubProcessTest.assertTrue((boolean)Arrays.asList("subProcessATask", "subProcessBTask").contains(subProcessChildren[0].getActivityId()));
        }
        this.taskService.complete(taskA.getId());
        this.taskService.complete(taskB.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        SubProcessTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTwoNestedSubProcessesInParallelWithTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedParallelSubProcessesWithTimer");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        SubProcessTest.assertEquals((String)"Task in subprocess A", (String)taskA.getName());
        SubProcessTest.assertEquals((String)"Task in subprocess B", (String)taskB.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Task taskAfterTimer = (Task)taskQuery.singleResult();
        SubProcessTest.assertEquals((String)"Task after timer", (String)taskAfterTimer.getName());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNestedSimpleSubProcessWithoutEndEvent() {
        this.testNestedSimpleSubProcess();
    }

    @Deployment
    public void testSimpleSubProcessWithoutEndEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testSimpleSubProcessWithoutEndEvent");
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testNestedSubProcessesWithoutEndEvents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testNestedSubProcessesWithoutEndEvents");
        this.assertProcessEnded(pi.getId());
    }
}

