/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Collections;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.SetTaskVariablesCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class ConcurrentVariableUpdateTest
extends PluggableProcessEngineTestCase {
    static ControllableThread activeThread;

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    public void FAILING_testConcurrentVariableCreate() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "varName";
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        thread2.proceedAndWaitTillDone();
        this.taskService.complete(taskId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    public void testConcurrentVariableUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "varName";
        this.taskService.setVariable(taskId, variableName, (Object)"someValue");
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, "someString");
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someOtherString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        thread2.proceedAndWaitTillDone();
        ConcurrentVariableUpdateTest.assertNull((Object)((Object)thread1.exception));
        ConcurrentVariableUpdateTest.assertNotNull((Object)((Object)thread2.exception));
        this.taskService.complete(taskId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/ConcurrentVariableUpdateTest.process.bpmn20.xml"})
    public void testConcurrentVariableUpdateTypeChange() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "varName";
        this.taskService.setVariable(taskId, variableName, (Object)"someValue");
        SetTaskVariablesThread thread1 = new SetTaskVariablesThread(taskId, variableName, (Object)100L);
        thread1.startAndWaitUntilControlIsReturned();
        SetTaskVariablesThread thread2 = new SetTaskVariablesThread(taskId, variableName, "someOtherString");
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        thread2.proceedAndWaitTillDone();
        ConcurrentVariableUpdateTest.assertNull((Object)((Object)thread1.exception));
        ConcurrentVariableUpdateTest.assertNotNull((Object)((Object)thread2.exception));
        this.taskService.complete(taskId);
    }

    class SetTaskVariablesThread
    extends ControllableThread {
        OptimisticLockingException exception;
        protected Object variableValue;
        protected String taskId;
        protected String variableName;

        public SetTaskVariablesThread(String taskId, String variableName, Object variableValue) {
            this.taskId = taskId;
            this.variableName = variableName;
            this.variableValue = variableValue;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                ConcurrentVariableUpdateTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)new SetTaskVariablesCmd(this.taskId, Collections.singletonMap(this.variableName, this.variableValue), false)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

