/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.tasklistener;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TaskListenerTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCreateListener() {
        this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskListenerTest.assertEquals((String)"Schedule meeting", (String)task.getName());
        TaskListenerTest.assertEquals((String)"TaskCreateListener is listening!", (String)task.getDescription());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCompleteListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        TaskListenerTest.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        TaskListenerTest.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "expressionValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        TaskListenerTest.assertEquals((Object)"Hello from The Process", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        TaskListenerTest.assertEquals((Object)"Act", (Object)this.runtimeService.getVariable(processInstance.getId(), "shortName"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskListenerWithExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        TaskListenerTest.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        TaskListenerTest.assertEquals((Object)"Write meeting notes", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
    }
}

