/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.usertask.taskcandidate;

import java.util.List;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TaskCandidateTest
extends PluggableProcessEngineTestCase {
    private static final String KERMIT = "kermit";
    private static final String GONZO = "gonzo";

    public void setUp() throws Exception {
        super.setUp();
        Group accountants = this.identityService.newGroup("accountancy");
        this.identityService.saveGroup(accountants);
        Group managers = this.identityService.newGroup("management");
        this.identityService.saveGroup(managers);
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User kermit = this.identityService.newUser(KERMIT);
        this.identityService.saveUser(kermit);
        this.identityService.createMembership(KERMIT, "accountancy");
        User gonzo = this.identityService.newUser(GONZO);
        this.identityService.saveUser(gonzo);
        this.identityService.createMembership(GONZO, "management");
        this.identityService.createMembership(GONZO, "accountancy");
        this.identityService.createMembership(GONZO, "sales");
    }

    public void tearDown() throws Exception {
        this.identityService.deleteUser(KERMIT);
        this.identityService.deleteUser(GONZO);
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        super.tearDown();
    }

    @Deployment
    public void testSingleCandidateGroup() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("singleCandidateGroup");
        List tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        TaskCandidateTest.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list();
        TaskCandidateTest.assertEquals((int)1, (int)tasks.size());
        Task task = (Task)tasks.get(0);
        TaskCandidateTest.assertEquals((String)"Pay out expenses", (String)task.getName());
        this.taskService.claim(task.getId(), KERMIT);
        tasks = this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list();
        TaskCandidateTest.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        TaskCandidateTest.assertEquals((int)1, (int)tasks.size());
        task = (Task)tasks.get(0);
        TaskCandidateTest.assertEquals((String)"Pay out expenses", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMultipleCandidateGroups() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("multipleCandidatesGroup");
        List tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        TaskCandidateTest.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskAssignee(GONZO).list();
        TaskCandidateTest.assertTrue((boolean)tasks.isEmpty());
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        TaskCandidateTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup("management").count());
        TaskCandidateTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup("accountancy").count());
        TaskCandidateTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateGroup("sales").count());
        tasks = this.taskService.createTaskQuery().taskCandidateUser(GONZO).list();
        Task task = (Task)tasks.get(0);
        TaskCandidateTest.assertEquals((String)"Approve expenses", (String)task.getName());
        this.taskService.claim(task.getId(), GONZO);
        TaskCandidateTest.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().isEmpty());
        TaskCandidateTest.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().isEmpty());
        TaskCandidateTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateGroup("management").count());
        TaskCandidateTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskAssignee(GONZO).count());
        TaskCandidateTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee(KERMIT).count());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMultipleCandidateUsers() {
        this.runtimeService.startProcessInstanceByKey("multipleCandidateUsersExample");
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
    }

    @Deployment
    public void testMixedCandidateUserAndGroup() {
        this.runtimeService.startProcessInstanceByKey("mixedCandidateUserAndGroupExample");
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        TaskCandidateTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
    }
}

